/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.variable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueWalker;
import org.drools.planner.core.move.CompositeMove;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanningVariableWalker
implements SolverPhaseLifecycleListener {
    private final PlanningEntityDescriptor planningEntityDescriptor;
    private List<PlanningValueWalker> planningValueWalkerList;
    private ScoreDirector scoreDirector;
    private Object planningEntity;

    public PlanningVariableWalker(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptor = planningEntityDescriptor;
    }

    public void setPlanningValueWalkerList(List<PlanningValueWalker> planningValueWalkerList) {
        this.planningValueWalkerList = planningValueWalkerList;
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.phaseStarted(solverPhaseScope);
        }
        this.scoreDirector = solverPhaseScope.getScoreDirector();
    }

    @Override
    public void beforeDeciding(AbstractStepScope stepScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.beforeDeciding(stepScope);
        }
    }

    @Override
    public void stepTaken(AbstractStepScope stepScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.stepTaken(stepScope);
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.phaseEnded(solverPhaseScope);
        }
        this.scoreDirector = null;
        this.planningEntity = null;
    }

    public void initWalk(Object planningEntity) {
        this.planningEntity = planningEntity;
        this.scoreDirector.beforeEntityAdded(planningEntity);
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.initWalk(planningEntity);
        }
        this.scoreDirector.afterEntityAdded(planningEntity);
    }

    public boolean hasWalk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            if (!planningValueWalker.hasWalk()) continue;
            return true;
        }
        return false;
    }

    public void walk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            if (planningValueWalker.hasWalk()) {
                planningValueWalker.walk();
                break;
            }
            planningValueWalker.resetWalk();
        }
    }

    public void resetWalk() {
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            planningValueWalker.resetWalk();
        }
    }

    public Iterator<Move> moveIterator(final Object planningEntity) {
        this.scoreDirector.beforeEntityAdded(planningEntity);
        this.scoreDirector.afterEntityAdded(planningEntity);
        if (this.planningValueWalkerList.size() == 1) {
            PlanningValueWalker planningValueWalker = this.planningValueWalkerList.iterator().next();
            return planningValueWalker.moveIterator(planningEntity);
        }
        final ArrayList<Iterator<Move>> moveIteratorList = new ArrayList<Iterator<Move>>(this.planningValueWalkerList.size());
        final ArrayList<Move> composedMoveList = new ArrayList<Move>(this.planningValueWalkerList.size());
        boolean moveIteratorIsFirst = true;
        for (PlanningValueWalker planningValueWalker : this.planningValueWalkerList) {
            Move initialMove;
            Iterator<Move> moveIterator = planningValueWalker.moveIterator(planningEntity);
            moveIteratorList.add(moveIterator);
            if (moveIteratorIsFirst) {
                initialMove = null;
                moveIteratorIsFirst = false;
            } else {
                if (!moveIterator.hasNext()) {
                    throw new IllegalStateException("The planning entity class (" + this.planningEntityDescriptor.getPlanningEntityClass() + ") for planning variable (" + planningValueWalker.getPlanningVariableDescriptor().getVariableName() + ") has an empty planning value range for planning entity (" + planningEntity + ").");
                }
                initialMove = moveIterator.next();
            }
            composedMoveList.add(initialMove);
        }
        return new Iterator<Move>(){

            @Override
            public boolean hasNext() {
                for (Iterator moveIterator : moveIteratorList) {
                    if (!moveIterator.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Move next() {
                for (int i = 0; i < moveIteratorList.size(); ++i) {
                    Iterator<Move> moveIterator = (Iterator<Move>)moveIteratorList.get(i);
                    if (moveIterator.hasNext()) {
                        composedMoveList.set(i, moveIterator.next());
                        break;
                    }
                    moveIterator = ((PlanningValueWalker)PlanningVariableWalker.this.planningValueWalkerList.get(i)).moveIterator(planningEntity);
                    moveIteratorList.set(i, moveIterator);
                    composedMoveList.set(i, moveIterator.next());
                }
                return new CompositeMove(new ArrayList<Move>(composedMoveList));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

