/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider;

import java.util.Iterator;
import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.localsearch.decider.selector.Selector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.director.ScoreDirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolverPhase localSearchSolverPhase;
    protected Selector selector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setLocalSearchSolverPhase(LocalSearchSolverPhase localSearchSolverPhase) {
        this.localSearchSolverPhase = localSearchSolverPhase;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
        selector.setDecider(this);
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.selector.phaseStarted(localSearchSolverPhaseScope);
        this.acceptor.phaseStarted(localSearchSolverPhaseScope);
        this.forager.phaseStarted(localSearchSolverPhaseScope);
    }

    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.selector.beforeDeciding(localSearchStepScope);
        this.acceptor.beforeDeciding(localSearchStepScope);
        this.forager.beforeDeciding(localSearchStepScope);
    }

    public void decideNextStep(LocalSearchStepScope stepScope) {
        MoveScope pickedMoveScope;
        ScoreDirector scoreDirector = stepScope.getScoreDirector();
        Iterator<Move> moveIterator = this.selector.moveIterator(stepScope);
        while (moveIterator.hasNext()) {
            Move move = moveIterator.next();
            MoveScope moveScope = new MoveScope(stepScope);
            moveScope.setMove(move);
            if (move.isMoveDoable(scoreDirector)) {
                this.doMove(moveScope);
                if (!this.forager.isQuitEarly()) continue;
                break;
            }
            this.logger.trace("        Ignoring not doable move ({}).", (Object)move);
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(MoveScope moveScope) {
        Score lastCompletedStepScore;
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope;
        Score undoScore;
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = (localSearchSolverPhaseScope = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope()).calculateScore()).equals(lastCompletedStepScore = localSearchSolverPhaseScope.getLastCompletedStepScope().getScore())) {
            scoreDirector.assertWorkingScore(undoScore);
            throw new IllegalStateException("The moveClass (" + move.getClass() + ")'s move (" + move + ") probably has a corrupted undoMove (" + undoMove + ")." + " Or maybe there are corrupted score rules.\n" + "Check the Move.createUndoMove(...) method of that Move class" + " and enable EnvironmentMode TRACE to fail-faster on corrupted score rules.\n" + "Score corruption: the lastCompletedStepScore (" + lastCompletedStepScore + ") is not the undoScore (" + undoScore + ").");
        }
        this.logger.trace("        Move score ({}), accepted ({}) for move ({}).", new Object[]{moveScope.getScore(), moveScope.getAccepted(), moveScope.getMove()});
    }

    private void processMove(MoveScope moveScope) {
        Score score = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().calculateScore();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().assertWorkingScore(score);
        }
        moveScope.setScore(score);
        boolean accepted = this.acceptor.isAccepted(moveScope);
        moveScope.setAccepted(accepted);
        this.forager.addMove(moveScope);
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.selector.stepTaken(localSearchStepScope);
        this.acceptor.stepTaken(localSearchStepScope);
        this.forager.stepTaken(localSearchStepScope);
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.selector.phaseEnded(localSearchSolverPhaseScope);
        this.acceptor.phaseEnded(localSearchSolverPhaseScope);
        this.forager.phaseEnded(localSearchSolverPhaseScope);
    }
}

