/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor;

import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAcceptor
extends AbstractAcceptor {
    protected List<Acceptor> acceptorList;

    public void setAcceptorList(List<Acceptor> acceptorList) {
        this.acceptorList = acceptorList;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseStarted(localSearchSolverPhaseScope);
        }
    }

    @Override
    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.beforeDeciding(localSearchStepScope);
        }
    }

    @Override
    public boolean isAccepted(MoveScope moveScope) {
        for (Acceptor acceptor : this.acceptorList) {
            boolean accepted = acceptor.isAccepted(moveScope);
            if (accepted) continue;
            return false;
        }
        return true;
    }

    @Override
    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.stepTaken(localSearchStepScope);
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        for (Acceptor acceptor : this.acceptorList) {
            acceptor.phaseEnded(localSearchSolverPhaseScope);
        }
    }
}

