/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class LegacySimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected double startingTemperature = -1.0;
    protected double temperatureSurvival = 0.997;
    protected double temperature;

    public void setStartingTemperature(double startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void setTemperatureSurvival(double temperatureSurvival) {
        this.temperatureSurvival = temperatureSurvival;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        if (this.startingTemperature <= 0.0) {
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot be negative or zero.");
        }
        if (this.temperatureSurvival <= 0.0) {
            throw new IllegalArgumentException("The temperatureSurvival (" + this.temperatureSurvival + ") cannot be negative or zero.");
        }
        this.temperature = this.startingTemperature;
    }

    public boolean isAccepted(MoveScope moveScope) {
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope();
        Score lastStepScore = localSearchSolverPhaseScope.getLastCompletedLocalSearchStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) > 0) {
            return true;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        Double diff = localSearchSolverPhaseScope.getScoreDefinition().translateScoreToGraphValue(scoreDifference);
        if (diff == null) {
            return false;
        }
        double acceptChance = Math.exp(-diff.doubleValue() / this.temperature);
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        super.stepTaken(localSearchStepScope);
        this.temperature *= this.temperatureSurvival;
    }
}

