/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.AbstractForager;
import org.drools.planner.core.localsearch.decider.forager.AcceptedMoveScopeComparator;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyType;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptedForager
extends AbstractForager {
    protected DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected final PickEarlyType pickEarlyType;
    protected final int minimalAcceptedSelection;
    protected Comparator<Score> scoreComparator;
    protected AcceptedMoveScopeComparator acceptedMoveScopeComparator;
    protected int selectedCount;
    protected List<MoveScope> acceptedList;
    protected List<MoveScope> maxScoreAcceptedList;
    protected Score maxScore;
    protected MoveScope earlyPickedMoveScope;

    public AcceptedForager(PickEarlyType pickEarlyType, int minimalAcceptedSelection) {
        this.pickEarlyType = pickEarlyType;
        this.minimalAcceptedSelection = minimalAcceptedSelection;
    }

    public void setDeciderScoreComparatorFactory(DeciderScoreComparatorFactory deciderScoreComparator) {
        this.deciderScoreComparatorFactory = deciderScoreComparator;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public void beforeDeciding(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.beforeDeciding(localSearchStepScope);
        this.scoreComparator = this.deciderScoreComparatorFactory.createDeciderScoreComparator();
        this.acceptedMoveScopeComparator = new AcceptedMoveScopeComparator(this.scoreComparator);
        this.selectedCount = 0;
        this.acceptedList = new ArrayList<MoveScope>(1024);
        this.maxScoreAcceptedList = new ArrayList<MoveScope>(1024);
        this.maxScore = localSearchStepScope.getSolverPhaseScope().getScoreDefinition().getPerfectMinimumScore();
        this.earlyPickedMoveScope = null;
    }

    @Override
    public void addMove(MoveScope moveScope) {
        ++this.selectedCount;
        if (moveScope.getAccepted().booleanValue()) {
            this.checkPickEarly(moveScope);
            this.addMoveScopeToAcceptedList(moveScope);
        }
    }

    protected void checkPickEarly(MoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                Score bestScore = moveScope.getLocalSearchStepScope().getSolverPhaseScope().getBestScore();
                if (this.scoreComparator.compare(moveScope.getScore(), bestScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                Score lastStepScore = moveScope.getLocalSearchStepScope().getSolverPhaseScope().getLastCompletedStepScope().getScore();
                if (this.scoreComparator.compare(moveScope.getScore(), lastStepScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented");
            }
        }
    }

    protected void addMoveScopeToAcceptedList(MoveScope moveScope) {
        this.acceptedList.add(moveScope);
        if (this.scoreComparator.compare(moveScope.getScore(), this.maxScore) > 0) {
            this.maxScore = moveScope.getScore();
            this.maxScoreAcceptedList.clear();
            this.maxScoreAcceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxScore)) {
            this.maxScoreAcceptedList.add(moveScope);
        }
    }

    @Override
    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedList.size() >= this.minimalAcceptedSelection;
    }

    @Override
    public MoveScope pickMove(LocalSearchStepScope localSearchStepScope) {
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.pickMaxScoreMoveScopeFromAcceptedList(localSearchStepScope);
    }

    protected MoveScope pickMaxScoreMoveScopeFromAcceptedList(LocalSearchStepScope localSearchStepScope) {
        if (this.maxScoreAcceptedList.isEmpty()) {
            return null;
        }
        if (this.maxScoreAcceptedList.size() == 1) {
            return this.maxScoreAcceptedList.get(0);
        }
        int randomIndex = localSearchStepScope.getWorkingRandom().nextInt(this.maxScoreAcceptedList.size());
        return this.maxScoreAcceptedList.get(randomIndex);
    }

    @Override
    public int getAcceptedMovesSize() {
        return this.acceptedList.size();
    }

    @Override
    public List<Move> getTopList(int topSize) {
        ArrayList<MoveScope> sortedAcceptedList = new ArrayList<MoveScope>(this.acceptedList);
        Collections.sort(sortedAcceptedList, this.acceptedMoveScopeComparator);
        int size = sortedAcceptedList.size();
        ArrayList<Move> topList = new ArrayList<Move>(Math.min(topSize, size));
        List subAcceptedList = sortedAcceptedList.subList(Math.max(0, size - topSize), size);
        for (MoveScope moveScope : subAcceptedList) {
            topList.add(moveScope.getMove());
        }
        return topList;
    }

    @Override
    public void stepTaken(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepTaken(localSearchStepScope);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseEnded(localSearchSolverPhaseScope);
    }
}

