/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.generic.GenericChangeMove;
import org.drools.planner.core.score.director.ScoreDirector;

public class GenericChainedChangeMove
extends GenericChangeMove {
    private final Object oldTrailingEntity;
    private final Object newTrailingEntity;

    public GenericChainedChangeMove(Object planningEntity, PlanningVariableDescriptor planningVariableDescriptor, Object toPlanningValue, Object oldTrailingEntity, Object newTrailingEntity) {
        super(planningEntity, planningVariableDescriptor, toPlanningValue);
        this.oldTrailingEntity = oldTrailingEntity;
        this.newTrailingEntity = newTrailingEntity;
    }

    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return super.isMoveDoable(scoreDirector) && !ObjectUtils.equals((Object)this.planningEntity, (Object)this.toPlanningValue);
    }

    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        return new GenericChainedChangeMove(this.planningEntity, this.planningVariableDescriptor, oldPlanningValue, this.newTrailingEntity, this.oldTrailingEntity);
    }

    public void doMove(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        if (this.oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(this.oldTrailingEntity, this.planningVariableDescriptor.getVariableName());
            this.planningVariableDescriptor.setValue(this.oldTrailingEntity, oldPlanningValue);
            scoreDirector.afterVariableChanged(this.oldTrailingEntity, this.planningVariableDescriptor.getVariableName());
        }
        scoreDirector.beforeVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.planningVariableDescriptor.setValue(this.planningEntity, this.toPlanningValue);
        scoreDirector.afterVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        if (this.newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(this.newTrailingEntity, this.planningVariableDescriptor.getVariableName());
            this.planningVariableDescriptor.setValue(this.newTrailingEntity, this.planningEntity);
            scoreDirector.afterVariableChanged(this.newTrailingEntity, this.planningVariableDescriptor.getVariableName());
        }
    }
}

