/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.move.generic.GenericChainedChangeMove;
import org.drools.planner.core.move.generic.GenericChangeMove;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChainedChangeMoveFactory
extends AbstractMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private ScoreDirector scoreDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.scoreDirector = localSearchSolverPhaseScope.getScoreDirector();
    }

    @Override
    public List<Move> createMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        Solution workingSolution = this.scoreDirector.getWorkingSolution();
        for (PlanningEntityDescriptor entityDescriptor : this.solutionDescriptor.getPlanningEntityDescriptors()) {
            for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getPlanningVariableDescriptors()) {
                Map<Object, List<Object>> variableToEntitiesMap = this.scoreDirector.getVariableToEntitiesMap(variableDescriptor);
                List<Object> entityList = entityDescriptor.extractEntities(workingSolution);
                for (Object entity : entityList) {
                    if (!variableDescriptor.isChained()) {
                        for (Object toPlanningValue : variableDescriptor.extractPlanningValues(workingSolution, entity)) {
                            moveList.add(new GenericChangeMove(entity, variableDescriptor, toPlanningValue));
                        }
                        continue;
                    }
                    Object oldTrailingEntity = this.findTrailingEntity(variableToEntitiesMap, variableDescriptor, entity);
                    for (Object toPlanningValue : variableDescriptor.extractPlanningValues(workingSolution, entity)) {
                        Object newTrailingEntity = this.findTrailingEntity(variableToEntitiesMap, variableDescriptor, toPlanningValue);
                        moveList.add(new GenericChainedChangeMove(entity, variableDescriptor, toPlanningValue, oldTrailingEntity, newTrailingEntity));
                    }
                }
            }
        }
        return moveList;
    }

    private Object findTrailingEntity(Map<Object, List<Object>> variableToEntitiesMap, PlanningVariableDescriptor variableDescriptor, Object planningValue) {
        List<Object> trailingEntities = variableToEntitiesMap.get(planningValue);
        if (trailingEntities == null) {
            return null;
        }
        if (trailingEntities.size() > 1) {
            throw new IllegalStateException("The planningValue (" + planningValue + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + variableDescriptor.getVariableName() + ").");
        }
        return trailingEntities.get(0);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.scoreDirector = null;
    }
}

