/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChainedChangePartMove
implements Move {
    private final List<Object> entitiesSubChain;
    private final Object firstEntity;
    private final Object lastEntity;
    private final PlanningVariableDescriptor planningVariableDescriptor;
    private final Object toPlanningValue;
    private final Object oldTrailingEntity;
    private final Object newTrailingEntity;

    public GenericChainedChangePartMove(List<Object> entitiesSubChain, PlanningVariableDescriptor planningVariableDescriptor, Object toPlanningValue, Object oldTrailingEntity, Object newTrailingEntity) {
        this.entitiesSubChain = entitiesSubChain;
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.toPlanningValue = toPlanningValue;
        this.oldTrailingEntity = oldTrailingEntity;
        this.newTrailingEntity = newTrailingEntity;
        this.firstEntity = this.entitiesSubChain.get(0);
        this.lastEntity = this.entitiesSubChain.get(entitiesSubChain.size() - 1);
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        return true;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldFirstPlanningValue = this.planningVariableDescriptor.getValue(this.firstEntity);
        return new GenericChainedChangePartMove(this.entitiesSubChain, this.planningVariableDescriptor, oldFirstPlanningValue, this.newTrailingEntity, this.oldTrailingEntity);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        Object oldFirstPlanningValue = this.planningVariableDescriptor.getValue(this.firstEntity);
        if (this.oldTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(this.oldTrailingEntity, this.planningVariableDescriptor.getVariableName());
            this.planningVariableDescriptor.setValue(this.oldTrailingEntity, oldFirstPlanningValue);
            scoreDirector.afterVariableChanged(this.oldTrailingEntity, this.planningVariableDescriptor.getVariableName());
        }
        for (Object entity : this.entitiesSubChain) {
            scoreDirector.beforeVariableChanged(entity, this.planningVariableDescriptor.getVariableName());
        }
        this.planningVariableDescriptor.setValue(this.firstEntity, this.toPlanningValue);
        for (Object entity : this.entitiesSubChain) {
            scoreDirector.afterVariableChanged(entity, this.planningVariableDescriptor.getVariableName());
        }
        if (this.newTrailingEntity != null) {
            scoreDirector.beforeVariableChanged(this.newTrailingEntity, this.planningVariableDescriptor.getVariableName());
            this.planningVariableDescriptor.setValue(this.newTrailingEntity, this.lastEntity);
            scoreDirector.afterVariableChanged(this.newTrailingEntity, this.planningVariableDescriptor.getVariableName());
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.entitiesSubChain;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericChainedChangePartMove) {
            GenericChainedChangePartMove other = (GenericChainedChangePartMove)o;
            return new EqualsBuilder().append(this.entitiesSubChain, other.entitiesSubChain).append((Object)this.planningVariableDescriptor.getVariableName(), (Object)other.planningVariableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.entitiesSubChain).append((Object)this.planningVariableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.entitiesSubChain + " => " + this.toPlanningValue;
    }
}

