/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.move.generic.GenericChainedChangePartMove;
import org.drools.planner.core.move.generic.GenericReverseChainedChangePartMove;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChainedChangePartMoveFactory
extends AbstractMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private ScoreDirector scoreDirector;
    private Integer maximumSubChainSize = null;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.scoreDirector = localSearchSolverPhaseScope.getScoreDirector();
    }

    @Override
    public List<Move> createMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        Solution workingSolution = this.scoreDirector.getWorkingSolution();
        for (PlanningEntityDescriptor entityDescriptor : this.solutionDescriptor.getPlanningEntityDescriptors()) {
            for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getPlanningVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                Map<Object, List<Object>> variableToEntitiesMap = this.scoreDirector.getVariableToEntitiesMap(variableDescriptor);
                Collection<?> values = variableDescriptor.extractAllPlanningValues(workingSolution);
                if (values.size() > 500) {
                    throw new IllegalStateException("TODO fix JBRULES-3371 so this works.");
                }
                for (Object anchor : values) {
                    if (entityDescriptor.getPlanningEntityClass().isAssignableFrom(anchor.getClass())) continue;
                    ArrayList<Object> anchorWithChain = new ArrayList<Object>(values.size());
                    anchorWithChain.add(anchor);
                    List<Object> trailingEntities = variableToEntitiesMap.get(anchor);
                    while (trailingEntities != null) {
                        if (trailingEntities.size() > 1) {
                            throw new IllegalStateException("The planningValue (" + anchor + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + variableDescriptor.getVariableName() + ").");
                        }
                        Object trailingEntity = trailingEntities.get(0);
                        anchorWithChain.add(trailingEntity);
                        trailingEntities = variableToEntitiesMap.get(trailingEntity);
                    }
                    int chainSize = anchorWithChain.size();
                    for (int fromIndex = 1; fromIndex < chainSize; ++fromIndex) {
                        Object oldToValue = anchorWithChain.get(fromIndex - 1);
                        for (int toIndex = fromIndex + 2; toIndex <= chainSize; ++toIndex) {
                            List<Object> entitiesSubChain = anchorWithChain.subList(fromIndex, toIndex);
                            Object oldTrailingEntity = toIndex < chainSize ? anchorWithChain.get(toIndex) : null;
                            for (Object toValue : values) {
                                if (entitiesSubChain.contains(toValue)) continue;
                                Object newTrailingEntity = this.findTrailingEntity(variableToEntitiesMap, variableDescriptor, toValue);
                                if (!oldToValue.equals(toValue)) {
                                    moveList.add(new GenericChainedChangePartMove(entitiesSubChain, variableDescriptor, toValue, oldTrailingEntity, newTrailingEntity));
                                }
                                if (chainSize == entitiesSubChain.size()) continue;
                                moveList.add(new GenericReverseChainedChangePartMove(entitiesSubChain, variableDescriptor, toValue, oldTrailingEntity, newTrailingEntity));
                            }
                        }
                    }
                }
            }
        }
        return moveList;
    }

    private Object findTrailingEntity(Map<Object, List<Object>> variableToEntitiesMap, PlanningVariableDescriptor variableDescriptor, Object planningValue) {
        List<Object> trailingEntities = variableToEntitiesMap.get(planningValue);
        if (trailingEntities == null) {
            return null;
        }
        if (trailingEntities.size() > 1) {
            throw new IllegalStateException("The planningValue (" + planningValue + ") has multiple trailing entities (" + trailingEntities + ") pointing to it for chained planningVariable (" + variableDescriptor.getVariableName() + ").");
        }
        return trailingEntities.get(0);
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.scoreDirector = null;
    }
}

