/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChainedSwapMoveFactory
extends AbstractMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private ScoreDirector scoreDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.scoreDirector = localSearchSolverPhaseScope.getScoreDirector();
    }

    @Override
    public List<Move> createMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        List<Object> entityList = this.solutionDescriptor.getPlanningEntityList(solution);
        ListIterator<Object> leftIt = entityList.listIterator();
        while (leftIt.hasNext()) {
            Object leftEntity = leftIt.next();
            PlanningEntityDescriptor leftEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(leftEntity.getClass());
            Collection<PlanningVariableDescriptor> variableDescriptors = leftEntityDescriptor.getPlanningVariableDescriptors();
            ListIterator<Object> rightIt = entityList.listIterator(leftIt.nextIndex());
            while (rightIt.hasNext()) {
                Object rightEntity = rightIt.next();
                PlanningEntityDescriptor rightEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(leftEntity.getClass());
                if (!leftEntityDescriptor.getPlanningEntityClass().equals(rightEntityDescriptor.getPlanningEntityClass())) continue;
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
        return moveList;
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.scoreDirector = null;
    }
}

