/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChangeMove
implements Move {
    protected final Object planningEntity;
    protected final PlanningVariableDescriptor planningVariableDescriptor;
    protected final Object toPlanningValue;

    public GenericChangeMove(Object planningEntity, PlanningVariableDescriptor planningVariableDescriptor, Object toPlanningValue) {
        this.planningEntity = planningEntity;
        this.planningVariableDescriptor = planningVariableDescriptor;
        this.toPlanningValue = toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        return !ObjectUtils.equals((Object)oldPlanningValue, (Object)this.toPlanningValue);
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        Object oldPlanningValue = this.planningVariableDescriptor.getValue(this.planningEntity);
        return new GenericChangeMove(this.planningEntity, this.planningVariableDescriptor, oldPlanningValue);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        scoreDirector.beforeVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
        this.planningVariableDescriptor.setValue(this.planningEntity, this.toPlanningValue);
        scoreDirector.afterVariableChanged(this.planningEntity, this.planningVariableDescriptor.getVariableName());
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.planningEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericChangeMove) {
            GenericChangeMove other = (GenericChangeMove)o;
            return new EqualsBuilder().append(this.planningEntity, other.planningEntity).append((Object)this.planningVariableDescriptor.getVariableName(), (Object)other.planningVariableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.planningEntity).append((Object)this.planningVariableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        return this.planningEntity + " => " + this.toPlanningValue;
    }
}

