/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.List;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.CachedMoveFactory;
import org.drools.planner.core.move.generic.GenericChangeMove;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericChangeMoveFactory
extends CachedMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private ScoreDirector scoreDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.scoreDirector = localSearchSolverPhaseScope.getScoreDirector();
        super.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public List<Move> createCachedMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        for (Object entity : this.solutionDescriptor.getPlanningEntityList(solution)) {
            PlanningEntityDescriptor entityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(entity.getClass());
            for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getPlanningVariableDescriptors()) {
                if (variableDescriptor.isChained()) {
                    throw new IllegalStateException("The planningEntityClass (" + entityDescriptor.getPlanningEntityClass() + ")'s planningVariableDescriptor (" + variableDescriptor.getVariableName() + ") is chained and can therefor not use the moveFactory (" + this.getClass() + ").");
                }
                for (Object toPlanningValue : variableDescriptor.extractPlanningValues(this.scoreDirector.getWorkingSolution(), entity)) {
                    moveList.add(new GenericChangeMove(entity, variableDescriptor, toPlanningValue));
                }
            }
        }
        return moveList;
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.scoreDirector = null;
    }
}

