/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapMove
implements Move {
    private final Collection<PlanningVariableDescriptor> planningVariableDescriptors;
    private final Object leftPlanningEntity;
    private final Object rightPlanningEntity;

    public GenericSwapMove(Collection<PlanningVariableDescriptor> planningVariableDescriptors, Object leftPlanningEntity, Object rightPlanningEntity) {
        this.planningVariableDescriptors = planningVariableDescriptors;
        this.leftPlanningEntity = leftPlanningEntity;
        this.rightPlanningEntity = rightPlanningEntity;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntity)))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new GenericSwapMove(this.planningVariableDescriptors, this.rightPlanningEntity, this.leftPlanningEntity);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntity);
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntity)))) continue;
            scoreDirector.beforeVariableChanged(this.leftPlanningEntity, planningVariableDescriptor.getVariableName());
            planningVariableDescriptor.setValue(this.leftPlanningEntity, rightValue);
            scoreDirector.afterVariableChanged(this.leftPlanningEntity, planningVariableDescriptor.getVariableName());
            scoreDirector.beforeVariableChanged(this.rightPlanningEntity, planningVariableDescriptor.getVariableName());
            planningVariableDescriptor.setValue(this.rightPlanningEntity, leftValue);
            scoreDirector.afterVariableChanged(this.rightPlanningEntity, planningVariableDescriptor.getVariableName());
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Arrays.asList(this.leftPlanningEntity, this.rightPlanningEntity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.planningVariableDescriptors.size() * 2);
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            values.add(planningVariableDescriptor.getValue(this.leftPlanningEntity));
            values.add(planningVariableDescriptor.getValue(this.rightPlanningEntity));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericSwapMove) {
            GenericSwapMove other = (GenericSwapMove)o;
            return new EqualsBuilder().append(this.leftPlanningEntity, other.leftPlanningEntity).append(this.rightPlanningEntity, other.rightPlanningEntity).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftPlanningEntity).append(this.rightPlanningEntity).toHashCode();
    }

    public String toString() {
        return this.leftPlanningEntity + " <=> " + this.rightPlanningEntity;
    }
}

