/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapPillarMove
implements Move {
    private final Collection<PlanningVariableDescriptor> planningVariableDescriptors;
    private final List<Object> leftPlanningEntityList;
    private final List<Object> rightPlanningEntityList;

    public GenericSwapPillarMove(Collection<PlanningVariableDescriptor> planningVariableDescriptors, List<Object> leftPlanningEntityList, List<Object> rightPlanningEntityList) {
        this.planningVariableDescriptors = planningVariableDescriptors;
        this.leftPlanningEntityList = leftPlanningEntityList;
        this.rightPlanningEntityList = rightPlanningEntityList;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntityList.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntityList.get(0))))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Move createUndoMove(ScoreDirector scoreDirector) {
        return new GenericSwapPillarMove(this.planningVariableDescriptors, this.rightPlanningEntityList, this.leftPlanningEntityList);
    }

    @Override
    public void doMove(ScoreDirector scoreDirector) {
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            Object rightValue;
            Object leftValue = planningVariableDescriptor.getValue(this.leftPlanningEntityList.get(0));
            if (ObjectUtils.equals((Object)leftValue, (Object)(rightValue = planningVariableDescriptor.getValue(this.rightPlanningEntityList.get(0))))) continue;
            for (Object leftPlanningEntity : this.leftPlanningEntityList) {
                scoreDirector.beforeVariableChanged(leftPlanningEntity, planningVariableDescriptor.getVariableName());
                planningVariableDescriptor.setValue(leftPlanningEntity, rightValue);
                scoreDirector.afterVariableChanged(leftPlanningEntity, planningVariableDescriptor.getVariableName());
            }
            for (Object rightPlanningEntity : this.rightPlanningEntityList) {
                scoreDirector.beforeVariableChanged(rightPlanningEntity, planningVariableDescriptor.getVariableName());
                planningVariableDescriptor.setValue(rightPlanningEntity, leftValue);
                scoreDirector.afterVariableChanged(rightPlanningEntity, planningVariableDescriptor.getVariableName());
            }
        }
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftPlanningEntityList.size() + this.rightPlanningEntityList.size());
        entities.addAll(this.leftPlanningEntityList);
        entities.addAll(this.rightPlanningEntityList);
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.planningVariableDescriptors.size() * 2);
        for (PlanningVariableDescriptor planningVariableDescriptor : this.planningVariableDescriptors) {
            values.add(planningVariableDescriptor.getValue(this.leftPlanningEntityList.get(0)));
            values.add(planningVariableDescriptor.getValue(this.rightPlanningEntityList.get(0)));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof GenericSwapPillarMove) {
            GenericSwapPillarMove other = (GenericSwapPillarMove)o;
            return new EqualsBuilder().append(this.leftPlanningEntityList, other.leftPlanningEntityList).append(this.rightPlanningEntityList, other.rightPlanningEntityList).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.leftPlanningEntityList).append(this.rightPlanningEntityList).toHashCode();
    }

    public String toString() {
        return this.leftPlanningEntityList + " <=> " + this.rightPlanningEntityList;
    }
}

