/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.move.generic.GenericSwapPillarMove;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSwapPillarMoveFactory
extends AbstractMoveFactory {
    private SolutionDescriptor solutionDescriptor;
    private ScoreDirector scoreDirector;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.solutionDescriptor = localSearchSolverPhaseScope.getSolutionDescriptor();
        this.scoreDirector = localSearchSolverPhaseScope.getScoreDirector();
        super.phaseStarted(localSearchSolverPhaseScope);
    }

    @Override
    public List<Move> createMoveList(Solution solution) {
        ArrayList<Move> moveList = new ArrayList<Move>();
        List<Object> globalEntityList = this.solutionDescriptor.getPlanningEntityList(solution);
        for (Class<?> entityClass : this.solutionDescriptor.getPlanningEntityImplementationClassSet()) {
            PlanningEntityDescriptor entityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(entityClass);
            Collection<PlanningVariableDescriptor> variableDescriptors = entityDescriptor.getPlanningVariableDescriptors();
            for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
                if (!variableDescriptor.isChained()) continue;
                throw new IllegalStateException("The planningEntityClass (" + variableDescriptor.getPlanningEntityDescriptor().getPlanningEntityClass() + ")'s planningVariableDescriptor (" + variableDescriptor.getVariableName() + ") is chained and can therefor not use the moveFactory (" + this.getClass() + ").");
            }
            List<List<Object>> swapEntityListList = this.buildSwapEntityListList(entityClass, variableDescriptors, globalEntityList);
            ListIterator<List<Object>> leftIt = swapEntityListList.listIterator();
            while (leftIt.hasNext()) {
                List<Object> leftEntityList = leftIt.next();
                ListIterator<List<Object>> rightIt = swapEntityListList.listIterator(leftIt.nextIndex());
                while (rightIt.hasNext()) {
                    List<Object> rightEntityList = rightIt.next();
                    moveList.add(new GenericSwapPillarMove(variableDescriptors, leftEntityList, rightEntityList));
                }
            }
        }
        return moveList;
    }

    private List<List<Object>> buildSwapEntityListList(Class<?> entityClass, Collection<PlanningVariableDescriptor> variableDescriptors, List<Object> globalEntityList) {
        LinkedHashMap valueStateToSwapEntityListMap = new LinkedHashMap(globalEntityList.size());
        for (Object entity : globalEntityList) {
            if (!entityClass.isInstance(entity)) continue;
            ArrayList<Object> valueState = new ArrayList<Object>(variableDescriptors.size());
            for (PlanningVariableDescriptor variableDescriptor : variableDescriptors) {
                Object value = variableDescriptor.getValue(entity);
                valueState.add(value);
            }
            ArrayList<Object> swapEntityList = (ArrayList<Object>)valueStateToSwapEntityListMap.get(valueState);
            if (swapEntityList == null) {
                swapEntityList = new ArrayList<Object>();
                valueStateToSwapEntityListMap.put(valueState, swapEntityList);
            }
            swapEntityList.add(entity);
        }
        return new ArrayList<List<Object>>(valueStateToSwapEntityListMap.values());
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.solutionDescriptor = null;
        this.scoreDirector = null;
    }
}

