/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase.custom;

import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.phase.custom.CustomSolverPhase;
import org.drools.planner.core.phase.custom.CustomSolverPhaseCommand;
import org.drools.planner.core.phase.custom.CustomSolverPhaseScope;
import org.drools.planner.core.phase.custom.CustomStepScope;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.solver.DefaultSolverScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCustomSolverPhase
extends AbstractSolverPhase
implements CustomSolverPhase {
    protected List<CustomSolverPhaseCommand> customSolverPhaseCommandList;

    public void setCustomSolverPhaseCommandList(List<CustomSolverPhaseCommand> customSolverPhaseCommandList) {
        this.customSolverPhaseCommandList = customSolverPhaseCommandList;
    }

    @Override
    public void solve(DefaultSolverScope solverScope) {
        CustomSolverPhaseScope customSolverPhaseScope = new CustomSolverPhaseScope(solverScope);
        this.phaseStarted(customSolverPhaseScope);
        CustomStepScope customStepScope = this.createNextStepScope(customSolverPhaseScope, null);
        Iterator<CustomSolverPhaseCommand> commandIterator = this.customSolverPhaseCommandList.iterator();
        while (!this.termination.isPhaseTerminated(customSolverPhaseScope) && commandIterator.hasNext()) {
            CustomSolverPhaseCommand customSolverPhaseCommand = commandIterator.next();
            customSolverPhaseCommand.changeWorkingSolution(solverScope.getScoreDirector());
            Score score = customSolverPhaseScope.calculateScore();
            customStepScope.setScore(score);
            this.stepTaken(customStepScope);
            customStepScope = this.createNextStepScope(customSolverPhaseScope, customStepScope);
        }
        this.phaseEnded(customSolverPhaseScope);
    }

    private CustomStepScope createNextStepScope(CustomSolverPhaseScope customSolverPhaseScope, CustomStepScope completedCustomStepScope) {
        if (completedCustomStepScope == null) {
            completedCustomStepScope = new CustomStepScope(customSolverPhaseScope);
            completedCustomStepScope.setScore(customSolverPhaseScope.getStartingScore());
            completedCustomStepScope.setStepIndex(-1);
        }
        customSolverPhaseScope.setLastCompletedCustomStepScope(completedCustomStepScope);
        CustomStepScope customStepScope = new CustomStepScope(customSolverPhaseScope);
        customStepScope.setStepIndex(completedCustomStepScope.getStepIndex() + 1);
        customStepScope.setSolutionInitialized(true);
        return customStepScope;
    }

    public void phaseStarted(CustomSolverPhaseScope customSolverPhaseScope) {
        super.phaseStarted(customSolverPhaseScope);
    }

    public void stepTaken(CustomStepScope customStepScope) {
        super.stepTaken(customStepScope);
        CustomSolverPhaseScope customSolverPhaseScope = customStepScope.getCustomSolverPhaseScope();
        this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}).", new Object[]{customStepScope.getStepIndex(), customSolverPhaseScope.calculateSolverTimeMillisSpend(), customStepScope.getScore(), customStepScope.getBestScoreImproved() != false ? "new" : "   ", customSolverPhaseScope.getBestScore()});
    }

    public void phaseEnded(CustomSolverPhaseScope customSolverPhaseScope) {
        super.phaseEnded(customSolverPhaseScope);
        this.logger.info("Phase custom ended: step total ({}), time spend ({}), best score ({}).", new Object[]{customSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, customSolverPhaseScope.calculateSolverTimeMillisSpend(), customSolverPhaseScope.getBestScore()});
    }
}

