/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardandsoft;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.hardandsoft.DefaultHardAndSoftScore;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScore;
import org.drools.planner.core.score.buildin.hardandsoft.HardAndSoftScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HardAndSoftScoreDefinition
extends AbstractScoreDefinition<HardAndSoftScore> {
    private double hardScoreTimeGradientWeight = 0.75;
    private HardAndSoftScore perfectMaximumScore = new DefaultHardAndSoftScore(0, 0);
    private HardAndSoftScore perfectMinimumScore = new DefaultHardAndSoftScore(Integer.MIN_VALUE, Integer.MIN_VALUE);

    public void setHardScoreTimeGradientWeight(double hardScoreTimeGradientWeight) {
        this.hardScoreTimeGradientWeight = hardScoreTimeGradientWeight;
        if (hardScoreTimeGradientWeight < 0.0 || hardScoreTimeGradientWeight > 1.0) {
            throw new IllegalArgumentException("Property hardScoreTimeGradientWeight (" + hardScoreTimeGradientWeight + ") must be greater or equal to 0.0 and smaller or equal to 1.0.");
        }
    }

    public void setPerfectMaximumScore(HardAndSoftScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(HardAndSoftScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public HardAndSoftScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public HardAndSoftScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Score parseScore(String scoreString) {
        return DefaultHardAndSoftScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(HardAndSoftScore startScore, HardAndSoftScore endScore, HardAndSoftScore score) {
        double timeGradient;
        double softScoreTimeGradientWeight;
        if (score.getHardScore() > endScore.getHardScore()) {
            return 1.0;
        }
        if (startScore.getHardScore() > score.getHardScore()) {
            return 0.0;
        }
        if (startScore.getHardScore() == endScore.getHardScore()) {
            softScoreTimeGradientWeight = 1.0;
            timeGradient = 0.0;
        } else {
            softScoreTimeGradientWeight = 1.0 - this.hardScoreTimeGradientWeight;
            int hardScoreTotal = endScore.getHardScore() - startScore.getHardScore();
            int hardScoreDelta = score.getHardScore() - startScore.getHardScore();
            double hardTimeGradient = (double)hardScoreDelta / (double)hardScoreTotal;
            timeGradient = hardTimeGradient * this.hardScoreTimeGradientWeight;
        }
        if (score.getSoftScore() >= endScore.getSoftScore()) {
            timeGradient += softScoreTimeGradientWeight;
        } else if (startScore.getSoftScore() < score.getSoftScore()) {
            int softScoreTotal = endScore.getSoftScore() - startScore.getSoftScore();
            int softScoreDelta = score.getSoftScore() - startScore.getSoftScore();
            double softTimeGradient = (double)softScoreDelta / (double)softScoreTotal;
            timeGradient += softTimeGradient * softScoreTimeGradientWeight;
        }
        return timeGradient;
    }

    @Override
    public Double translateScoreToGraphValue(HardAndSoftScore score) {
        if (score.getHardScore() == 0) {
            return score.getSoftScore();
        }
        return null;
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new HardAndSoftScoreHolder();
    }
}

