/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.hardandsoftlong;

import org.drools.planner.core.score.AbstractScore;
import org.drools.planner.core.score.buildin.hardandsoftlong.HardAndSoftLongScore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultHardAndSoftLongScore
extends AbstractScore<HardAndSoftLongScore>
implements HardAndSoftLongScore {
    private static final String HARD_LABEL = "hard";
    private static final String SOFT_LABEL = "soft";
    private final long hardScore;
    private final long softScore;

    public static DefaultHardAndSoftLongScore parseScore(String scoreString) {
        String[] scoreTokens = scoreString.split("hard\\/");
        if (scoreTokens.length != 2 || !scoreTokens[1].endsWith(SOFT_LABEL)) {
            throw new IllegalArgumentException("The scoreString (" + scoreString + ") doesn't follow the 999hard/999soft pattern.");
        }
        long hardScore = Long.parseLong(scoreTokens[0]);
        long softScore = Long.parseLong(scoreTokens[1].substring(0, scoreTokens[1].length() - SOFT_LABEL.length()));
        return DefaultHardAndSoftLongScore.valueOf(hardScore, softScore);
    }

    public static DefaultHardAndSoftLongScore valueOf(long hardScore) {
        return new DefaultHardAndSoftLongScore(hardScore);
    }

    public static DefaultHardAndSoftLongScore valueOf(long hardScore, long softScore) {
        return new DefaultHardAndSoftLongScore(hardScore, softScore);
    }

    public DefaultHardAndSoftLongScore(long hardScore) {
        this(hardScore, Long.MIN_VALUE);
    }

    public DefaultHardAndSoftLongScore(long hardScore, long softScore) {
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    @Override
    public long getHardScore() {
        return this.hardScore;
    }

    @Override
    public long getSoftScore() {
        return this.softScore;
    }

    @Override
    public boolean isFeasible() {
        return this.getHardScore() >= 0L;
    }

    @Override
    public HardAndSoftLongScore add(HardAndSoftLongScore augment) {
        return new DefaultHardAndSoftLongScore(this.hardScore + augment.getHardScore(), this.softScore + augment.getSoftScore());
    }

    @Override
    public HardAndSoftLongScore subtract(HardAndSoftLongScore subtrahend) {
        return new DefaultHardAndSoftLongScore(this.hardScore - subtrahend.getHardScore(), this.softScore - subtrahend.getSoftScore());
    }

    @Override
    public HardAndSoftLongScore multiply(double multiplicand) {
        return new DefaultHardAndSoftLongScore((long)Math.floor((double)this.hardScore * multiplicand), (long)Math.floor((double)this.softScore * multiplicand));
    }

    @Override
    public HardAndSoftLongScore divide(double divisor) {
        return new DefaultHardAndSoftLongScore((long)Math.floor((double)this.hardScore / divisor), (long)Math.floor((double)this.softScore / divisor));
    }

    @Override
    public double[] toDoubleArray() {
        return new double[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof HardAndSoftLongScore) {
            HardAndSoftLongScore other = (HardAndSoftLongScore)o;
            return this.hardScore == other.getHardScore() && this.softScore == other.getSoftScore();
        }
        return false;
    }

    public int hashCode() {
        return (629 + Long.valueOf(this.hardScore).hashCode()) * 37 + Long.valueOf(this.softScore).hashCode();
    }

    @Override
    public int compareTo(HardAndSoftLongScore other) {
        if (this.hardScore != other.getHardScore()) {
            if (this.hardScore < other.getHardScore()) {
                return -1;
            }
            return 1;
        }
        if (this.softScore < other.getSoftScore()) {
            return -1;
        }
        if (this.softScore > other.getSoftScore()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.hardScore + HARD_LABEL + "/" + this.softScore + SOFT_LABEL;
    }
}

