/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.buildin.simple;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.buildin.simple.DefaultSimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScore;
import org.drools.planner.core.score.buildin.simple.SimpleScoreHolder;
import org.drools.planner.core.score.definition.AbstractScoreDefinition;
import org.drools.planner.core.score.holder.ScoreHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleScoreDefinition
extends AbstractScoreDefinition<SimpleScore> {
    private SimpleScore perfectMaximumScore = new DefaultSimpleScore(0);
    private SimpleScore perfectMinimumScore = new DefaultSimpleScore(Integer.MIN_VALUE);

    public void setPerfectMaximumScore(SimpleScore perfectMaximumScore) {
        this.perfectMaximumScore = perfectMaximumScore;
    }

    public void setPerfectMinimumScore(SimpleScore perfectMinimumScore) {
        this.perfectMinimumScore = perfectMinimumScore;
    }

    @Override
    public SimpleScore getPerfectMaximumScore() {
        return this.perfectMaximumScore;
    }

    @Override
    public SimpleScore getPerfectMinimumScore() {
        return this.perfectMinimumScore;
    }

    @Override
    public Score parseScore(String scoreString) {
        return DefaultSimpleScore.parseScore(scoreString);
    }

    @Override
    public double calculateTimeGradient(SimpleScore startScore, SimpleScore endScore, SimpleScore score) {
        if (score.getScore() >= endScore.getScore()) {
            return 1.0;
        }
        if (startScore.getScore() >= score.getScore()) {
            return 0.0;
        }
        int scoreTotal = endScore.getScore() - startScore.getScore();
        int scoreDelta = score.getScore() - startScore.getScore();
        return (double)scoreDelta / (double)scoreTotal;
    }

    @Override
    public Double translateScoreToGraphValue(SimpleScore score) {
        return score.getScore();
    }

    @Override
    public ScoreHolder buildScoreHolder() {
        return new SimpleScoreHolder();
    }
}

