/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.ScoreDirectorFactory;
import org.drools.planner.core.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScoreDirector<F extends ScoreDirectorFactory>
implements ScoreDirector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final F scoreDirectorFactory;
    protected Solution workingSolution;
    protected long calculateCount = 0L;

    protected AbstractScoreDirector(F scoreDirectorFactory) {
        this.scoreDirectorFactory = scoreDirectorFactory;
    }

    @Override
    public SolutionDescriptor getSolutionDescriptor() {
        return this.scoreDirectorFactory.getSolutionDescriptor();
    }

    @Override
    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirectorFactory.getScoreDefinition();
    }

    @Override
    public Solution getWorkingSolution() {
        return this.workingSolution;
    }

    @Override
    public long getCalculateCount() {
        return this.calculateCount;
    }

    @Override
    public List<Object> getWorkingPlanningEntityList() {
        return this.getSolutionDescriptor().getPlanningEntityList(this.workingSolution);
    }

    @Override
    public boolean isWorkingSolutionInitialized() {
        return this.getSolutionDescriptor().isInitialized(this.workingSolution);
    }

    @Override
    public Map<Object, List<Object>> getVariableToEntitiesMap(PlanningVariableDescriptor variableDescriptor) {
        List<Object> entityList = variableDescriptor.getPlanningEntityDescriptor().extractEntities(this.workingSolution);
        HashMap<Object, List<Object>> variableToEntitiesMap = new HashMap<Object, List<Object>>(entityList.size());
        for (Object entity : entityList) {
            Object variable = variableDescriptor.getValue(entity);
            ArrayList<Object> subEntities = (ArrayList<Object>)variableToEntitiesMap.get(variable);
            if (subEntities == null) {
                subEntities = new ArrayList<Object>();
                variableToEntitiesMap.put(variable, subEntities);
            }
            subEntities.add(entity);
        }
        return variableToEntitiesMap;
    }

    @Override
    public void assertWorkingScore(Score workingScore) {
        ScoreDirector uncorruptedScoreDirector = this.scoreDirectorFactory.buildScoreDirector();
        uncorruptedScoreDirector.setWorkingSolution(this.workingSolution);
        Score uncorruptedScore = uncorruptedScoreDirector.calculateScore();
        if (!workingScore.equals(uncorruptedScore)) {
            String scoreCorruptionAnalysis = this.buildScoreCorruptionAnalysis(uncorruptedScoreDirector);
            uncorruptedScoreDirector.dispose();
            throw new IllegalStateException("Score corruption: the workingScore (" + workingScore + ") is not the uncorruptedScore (" + uncorruptedScore + ")" + (scoreCorruptionAnalysis == null ? "." : ":\n" + scoreCorruptionAnalysis));
        }
        uncorruptedScoreDirector.dispose();
    }

    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        return null;
    }
}

