/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director.drools;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.drools.ClassObjectFilter;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.constraint.ConstraintOccurrence;
import org.drools.planner.core.score.director.AbstractScoreDirector;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.score.director.drools.DroolsScoreDirectorFactory;
import org.drools.planner.core.score.holder.ScoreHolder;
import org.drools.planner.core.solution.Solution;
import org.drools.runtime.ObjectFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsScoreDirector
extends AbstractScoreDirector<DroolsScoreDirectorFactory> {
    public static final String GLOBAL_SCORE_HOLDER_KEY = "scoreHolder";
    protected StatefulSession workingMemory;
    protected ScoreHolder workingScoreHolder;

    public DroolsScoreDirector(DroolsScoreDirectorFactory scoreDirectorFactory) {
        super(scoreDirectorFactory);
    }

    protected RuleBase getRuleBase() {
        return ((DroolsScoreDirectorFactory)this.scoreDirectorFactory).getRuleBase();
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.resetWorkingMemory();
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    private void resetWorkingMemory() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
        }
        this.workingMemory = this.getRuleBase().newStatefulSession();
        this.workingScoreHolder = this.getScoreDefinition().buildScoreHolder();
        this.workingMemory.setGlobal(GLOBAL_SCORE_HOLDER_KEY, (Object)this.workingScoreHolder);
        for (Object fact : this.getWorkingFacts()) {
            this.workingMemory.insert(fact);
        }
    }

    public Collection<Object> getWorkingFacts() {
        return this.getSolutionDescriptor().getAllFacts(this.workingSolution);
    }

    @Override
    public void beforeEntityAdded(Object entity) {
    }

    @Override
    public void afterEntityAdded(Object entity) {
        if (entity == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") cannot be added to the ScoreDirector.");
        }
        if (!this.getSolutionDescriptor().hasPlanningEntityDescriptor(entity.getClass())) {
            throw new IllegalArgumentException("The entity (" + entity + ") of class (" + entity.getClass() + ") is not a configured @PlanningEntity.");
        }
        this.workingMemory.insert(entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        FactHandle factHandle = this.workingMemory.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.");
        }
        this.workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.beforeAllVariablesChanged(entity);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.afterAllVariablesChanged(entity);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
    }

    @Override
    public void afterEntityRemoved(Object entity) {
        FactHandle factHandle = this.workingMemory.getFactHandle(entity);
        if (factHandle == null) {
            throw new IllegalArgumentException("The entity (" + entity + ") was never added to this ScoreDirector.");
        }
        this.workingMemory.retract((org.drools.runtime.rule.FactHandle)factHandle);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.workingMemory.insert(problemFact);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        FactHandle factHandle = this.workingMemory.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector.");
        }
        this.workingMemory.update((org.drools.runtime.rule.FactHandle)factHandle, problemFact);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        FactHandle factHandle = this.workingMemory.getFactHandle(problemFact);
        if (factHandle == null) {
            throw new IllegalArgumentException("The problemFact (" + problemFact + ") was never added to this ScoreDirector.");
        }
        this.workingMemory.retract((org.drools.runtime.rule.FactHandle)factHandle);
    }

    @Override
    public Score calculateScore() {
        this.workingMemory.fireAllRules();
        Score score = this.workingScoreHolder.extractScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    @Override
    protected String buildScoreCorruptionAnalysis(ScoreDirector uncorruptedScoreDirector) {
        int count;
        DroolsScoreDirector uncorruptedDroolsScoreDirector = (DroolsScoreDirector)uncorruptedScoreDirector;
        LinkedHashSet workingConstraintOccurrenceSet = new LinkedHashSet();
        Iterator workingIt = this.workingMemory.iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (workingIt.hasNext()) {
            workingConstraintOccurrenceSet.add(workingIt.next());
        }
        LinkedHashSet uncorruptedConstraintOccurrenceSet = new LinkedHashSet();
        Iterator uncorruptedIt = uncorruptedDroolsScoreDirector.getWorkingMemory().iterateObjects((ObjectFilter)new ClassObjectFilter(ConstraintOccurrence.class));
        while (uncorruptedIt.hasNext()) {
            uncorruptedConstraintOccurrenceSet.add(uncorruptedIt.next());
        }
        LinkedHashSet excessSet = new LinkedHashSet(workingConstraintOccurrenceSet);
        excessSet.removeAll(uncorruptedConstraintOccurrenceSet);
        LinkedHashSet lackingSet = new LinkedHashSet(uncorruptedConstraintOccurrenceSet);
        lackingSet.removeAll(workingConstraintOccurrenceSet);
        int CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT = 10;
        StringBuilder analysis = new StringBuilder();
        if (!excessSet.isEmpty()) {
            analysis.append("  The workingMemory has ").append(excessSet.size()).append(" ConstraintOccurrence(s) in excess:\n");
            count = 0;
            for (Object o : excessSet) {
                if (count >= CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT) {
                    analysis.append("    ... ").append(excessSet.size() - CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT).append(" more\n");
                    break;
                }
                analysis.append("    ").append(o.toString()).append("\n");
                ++count;
            }
        }
        if (!lackingSet.isEmpty()) {
            analysis.append("  The workingMemory has ").append(excessSet.size()).append(" ConstraintOccurrence(s) lacking:\n");
            count = 0;
            for (Object o : lackingSet) {
                if (count >= CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT) {
                    analysis.append("    ... ").append(lackingSet.size() - CONSTRAINT_OCCURRENCE_DISPLAY_LIMIT).append(" more\n");
                    break;
                }
                analysis.append("    ").append(o.toString()).append("\n");
                ++count;
            }
        }
        if (excessSet.isEmpty() && lackingSet.isEmpty()) {
            analysis.append("  Check the score rules. No ConstraintOccurrence(s) in excess or lacking.  Possibly some logically inserted score rules do not extend ConstraintOccurrence.\n  Consider making them extend ConstraintOccurrence or just reuse the build-in ConstraintOccurrence implementations.");
        } else {
            analysis.append("  Check the score rules who created those ConstraintOccurrences. Verify that each ConstraintOccurrence's causes and weight is correct.");
        }
        return analysis.toString();
    }

    @Override
    public void dispose() {
        if (this.workingMemory != null) {
            this.workingMemory.dispose();
            this.workingMemory = null;
        }
    }
}

