/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.score.director.incremental;

import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.director.AbstractScoreDirector;
import org.drools.planner.core.score.director.incremental.IncrementalScoreCalculator;
import org.drools.planner.core.score.director.incremental.IncrementalScoreDirectorFactory;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalScoreDirector
extends AbstractScoreDirector<IncrementalScoreDirectorFactory> {
    private final IncrementalScoreCalculator incrementalScoreCalculator;

    public IncrementalScoreDirector(IncrementalScoreDirectorFactory scoreDirectorFactory, IncrementalScoreCalculator incrementalScoreCalculator) {
        super(scoreDirectorFactory);
        this.incrementalScoreCalculator = incrementalScoreCalculator;
    }

    @Override
    public void setWorkingSolution(Solution workingSolution) {
        this.workingSolution = workingSolution;
        this.incrementalScoreCalculator.resetWorkingSolution(workingSolution);
    }

    @Override
    public void beforeEntityAdded(Object entity) {
        this.incrementalScoreCalculator.beforeEntityAdded(entity);
    }

    @Override
    public void afterEntityAdded(Object entity) {
        this.incrementalScoreCalculator.afterEntityAdded(entity);
    }

    @Override
    public void beforeAllVariablesChanged(Object entity) {
        this.incrementalScoreCalculator.beforeAllVariablesChanged(entity);
    }

    @Override
    public void afterAllVariablesChanged(Object entity) {
        this.incrementalScoreCalculator.afterAllVariablesChanged(entity);
    }

    @Override
    public void beforeVariableChanged(Object entity, String variableName) {
        this.incrementalScoreCalculator.beforeVariableChanged(entity, variableName);
    }

    @Override
    public void afterVariableChanged(Object entity, String variableName) {
        this.incrementalScoreCalculator.afterVariableChanged(entity, variableName);
    }

    @Override
    public void beforeEntityRemoved(Object entity) {
        this.incrementalScoreCalculator.beforeEntityRemoved(entity);
    }

    @Override
    public void afterEntityRemoved(Object entity) {
        this.incrementalScoreCalculator.afterEntityRemoved(entity);
    }

    @Override
    public void beforeProblemFactAdded(Object problemFact) {
    }

    @Override
    public void afterProblemFactAdded(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public void beforeProblemFactChanged(Object problemFact) {
    }

    @Override
    public void afterProblemFactChanged(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public void beforeProblemFactRemoved(Object problemFact) {
    }

    @Override
    public void afterProblemFactRemoved(Object problemFact) {
        this.incrementalScoreCalculator.resetWorkingSolution(this.workingSolution);
    }

    @Override
    public Score calculateScore() {
        Score score = this.incrementalScoreCalculator.calculateScore();
        this.workingSolution.setScore(score);
        ++this.calculateCount;
        return score;
    }

    @Override
    public void dispose() {
    }
}

