/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.solver;

import java.util.List;
import java.util.Random;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.definition.ScoreDefinition;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSolverScope {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean restartSolver = false;
    protected long startingSystemTimeMillis;
    protected ScoreDirector scoreDirector;
    protected Random workingRandom;
    protected Score startingInitializedScore;
    protected Solution bestSolution;
    protected Score bestScore;

    public boolean isRestartSolver() {
        return this.restartSolver;
    }

    public long getStartingSystemTimeMillis() {
        return this.startingSystemTimeMillis;
    }

    public void setStartingSystemTimeMillis(long startingSystemTimeMillis) {
        this.startingSystemTimeMillis = startingSystemTimeMillis;
    }

    public void setRestartSolver(boolean restartSolver) {
        this.restartSolver = restartSolver;
    }

    public ScoreDirector getScoreDirector() {
        return this.scoreDirector;
    }

    public void setScoreDirector(ScoreDirector scoreDirector) {
        this.scoreDirector = scoreDirector;
    }

    public SolutionDescriptor getSolutionDescriptor() {
        return this.scoreDirector.getSolutionDescriptor();
    }

    public ScoreDefinition getScoreDefinition() {
        return this.scoreDirector.getScoreDefinition();
    }

    public Solution getWorkingSolution() {
        return this.scoreDirector.getWorkingSolution();
    }

    public List<Object> getWorkingPlanningEntityList() {
        return this.scoreDirector.getWorkingPlanningEntityList();
    }

    public boolean isWorkingSolutionInitialized() {
        return this.scoreDirector.isWorkingSolutionInitialized();
    }

    public Score calculateScore() {
        return this.scoreDirector.calculateScore();
    }

    public void assertWorkingScore(Score workingScore) {
        this.scoreDirector.assertWorkingScore(workingScore);
    }

    public Random getWorkingRandom() {
        return this.workingRandom;
    }

    public void setWorkingRandom(Random workingRandom) {
        this.workingRandom = workingRandom;
    }

    public Score getStartingInitializedScore() {
        return this.startingInitializedScore;
    }

    public void setStartingInitializedScore(Score startingInitializedScore) {
        this.startingInitializedScore = startingInitializedScore;
    }

    public long getCalculateCount() {
        return this.scoreDirector.getCalculateCount();
    }

    public Solution getBestSolution() {
        return this.bestSolution;
    }

    public void setBestSolution(Solution bestSolution) {
        this.bestSolution = bestSolution;
    }

    public Score getBestScore() {
        return this.bestScore;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public long calculateTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public void setWorkingSolutionFromBestSolution() {
        this.scoreDirector.setWorkingSolution(this.getBestSolution().cloneSolution());
    }
}

