/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractCompositeTermination;
import org.drools.planner.core.termination.Termination;

public class OrCompositeTermination
extends AbstractCompositeTermination {
    public OrCompositeTermination() {
    }

    public OrCompositeTermination(Termination ... terminations) {
        super(terminations);
    }

    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isSolverTerminated(solverScope)) continue;
            return true;
        }
        return false;
    }

    public boolean isPhaseTerminated(AbstractSolverPhaseScope solverPhaseScope) {
        for (Termination termination : this.terminationList) {
            if (!termination.isPhaseTerminated(solverPhaseScope)) continue;
            return true;
        }
        return false;
    }

    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculateSolverTimeGradient(solverScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }

    public double calculatePhaseTimeGradient(AbstractSolverPhaseScope solverPhaseScope) {
        double timeGradient = 0.0;
        for (Termination termination : this.terminationList) {
            double nextTimeGradient = termination.calculatePhaseTimeGradient(solverPhaseScope);
            if (!(nextTimeGradient >= 0.0)) continue;
            timeGradient = Math.max(timeGradient, nextTimeGradient);
        }
        return timeGradient;
    }
}

