/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.machinereassignment.swingui;

import java.awt.GridLayout;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.common.swingui.SolutionPanel;
import org.drools.planner.examples.machinereassignment.domain.MachineReassignment;
import org.drools.planner.examples.machinereassignment.domain.MrMachine;
import org.drools.planner.examples.machinereassignment.domain.MrProcessAssignment;
import org.drools.planner.examples.machinereassignment.domain.MrResource;
import org.drools.planner.examples.machinereassignment.swingui.MrMachinePanel;

public class MachineReassignmentPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/machinereassignment/swingui/machineReassignmentLogo.png";
    private JPanel machineListPanel;
    private MrMachinePanel unassignedPanel;
    private Map<MrMachine, MrMachinePanel> machineToPanelMap;
    private Map<MrProcessAssignment, MrMachinePanel> processAssignmentToPanelMap;

    public MachineReassignmentPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        this.createMachineListPanel();
        JPanel headerPanel = new JPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(this.machineListPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(this.machineListPanel, -2, -2, -2));
    }

    private void createMachineListPanel() {
        this.machineListPanel = new JPanel(new GridLayout(0, 1));
        this.unassignedPanel = new MrMachinePanel(this, Collections.<MrResource>emptyList(), null);
        this.machineListPanel.add(this.unassignedPanel);
        this.machineToPanelMap = new LinkedHashMap<MrMachine, MrMachinePanel>();
        this.machineToPanelMap.put(null, this.unassignedPanel);
        this.processAssignmentToPanelMap = new LinkedHashMap<MrProcessAssignment, MrMachinePanel>();
    }

    private MachineReassignment getMachineReassignment() {
        return (MachineReassignment)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
            if (machinePanel.getMachine() == null) continue;
            this.machineListPanel.remove(machinePanel);
        }
        this.machineToPanelMap.clear();
        this.machineToPanelMap.put(null, this.unassignedPanel);
        this.processAssignmentToPanelMap.clear();
        this.unassignedPanel.clearMrProcessAssignments();
        this.updatePanel(solution);
    }

    public void updatePanel(Solution solution) {
        MrMachinePanel deadMachinePanel;
        MachineReassignment machineReassignment = (MachineReassignment)solution;
        List<MrResource> resourceList = machineReassignment.getResourceList();
        this.unassignedPanel.setResourceList(resourceList);
        LinkedHashSet<MrMachine> deadMachineSet = new LinkedHashSet<MrMachine>(this.machineToPanelMap.keySet());
        deadMachineSet.remove(null);
        for (MrMachine machine : machineReassignment.getMachineList()) {
            deadMachineSet.remove(machine);
            MrMachinePanel machinePanel = this.machineToPanelMap.get(machine);
            if (machinePanel != null) continue;
            machinePanel = new MrMachinePanel(this, resourceList, machine);
            this.machineListPanel.add(machinePanel);
            this.machineToPanelMap.put(machine, machinePanel);
        }
        LinkedHashSet<MrProcessAssignment> deadProcessAssignmentSet = new LinkedHashSet<MrProcessAssignment>(this.processAssignmentToPanelMap.keySet());
        for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
            deadProcessAssignmentSet.remove(processAssignment);
            MrMachinePanel machinePanel = this.processAssignmentToPanelMap.get(processAssignment);
            MrMachine machine = processAssignment.getMachine();
            if (machinePanel != null && !ObjectUtils.equals((Object)machinePanel.getMachine(), (Object)machine)) {
                this.processAssignmentToPanelMap.remove(processAssignment);
                machinePanel.removeMrProcessAssignment(processAssignment);
                machinePanel = null;
            }
            if (machinePanel != null) continue;
            machinePanel = this.machineToPanelMap.get(machine);
            machinePanel.addMrProcessAssignment(processAssignment);
            this.processAssignmentToPanelMap.put(processAssignment, machinePanel);
        }
        for (MrProcessAssignment deadProcessAssignment : deadProcessAssignmentSet) {
            deadMachinePanel = this.processAssignmentToPanelMap.remove(deadProcessAssignment);
            deadMachinePanel.removeMrProcessAssignment(deadProcessAssignment);
        }
        for (MrMachine deadMachine : deadMachineSet) {
            deadMachinePanel = this.machineToPanelMap.remove(deadMachine);
            this.machineListPanel.remove(deadMachinePanel);
        }
        for (MrMachinePanel machinePanel : this.machineToPanelMap.values()) {
            machinePanel.update();
        }
    }

    public void deleteMachine(final MrMachine machine) {
        this.logger.info("Scheduling delete of machine ({}).", (Object)machine);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                MachineReassignment machineReassignment = (MachineReassignment)scoreDirector.getWorkingSolution();
                for (MrProcessAssignment processAssignment : machineReassignment.getProcessAssignmentList()) {
                    if (!ObjectUtils.equals((Object)processAssignment.getMachine(), (Object)machine)) continue;
                    scoreDirector.beforeEntityRemoved(processAssignment);
                    processAssignment.setMachine(null);
                    scoreDirector.afterEntityRemoved(processAssignment);
                }
                Iterator<MrMachine> it = machineReassignment.getMachineList().iterator();
                while (it.hasNext()) {
                    MrMachine workingMachine = it.next();
                    if (!ObjectUtils.equals((Object)workingMachine, (Object)machine)) continue;
                    scoreDirector.beforeProblemFactRemoved(workingMachine);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved(workingMachine);
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }
}

