/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.travelingtournament.solver.smart.move.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.move.factory.AbstractMoveFactory;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.examples.travelingtournament.domain.Day;
import org.drools.planner.examples.travelingtournament.domain.Match;
import org.drools.planner.examples.travelingtournament.domain.Team;
import org.drools.planner.examples.travelingtournament.domain.TravelingTournament;
import org.drools.planner.examples.travelingtournament.solver.smart.move.MatchSwapMove;
import org.drools.planner.examples.travelingtournament.solver.smart.move.MultipleMatchListRotateMove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartTravelingTournamentMoveFactory
extends AbstractMoveFactory {
    private List<Move> cachedMoveList;

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        TravelingTournament travelingTournament = (TravelingTournament)localSearchSolverPhaseScope.getWorkingSolution();
        this.cachedMoveList = new ArrayList<Move>(travelingTournament.getMatchList().size() / 2);
        this.addCachedHomeAwaySwapMoves(travelingTournament);
    }

    private void addCachedHomeAwaySwapMoves(TravelingTournament travelingTournament) {
        List<Match> matchList = travelingTournament.getMatchList();
        block0: for (Match firstMatch : matchList) {
            for (Match secondMatch : matchList) {
                if (!firstMatch.getHomeTeam().equals(secondMatch.getAwayTeam()) || !firstMatch.getAwayTeam().equals(secondMatch.getHomeTeam()) || firstMatch.getId().compareTo(secondMatch.getId()) >= 0) continue;
                MatchSwapMove matchSwapMove = new MatchSwapMove(firstMatch, secondMatch);
                this.cachedMoveList.add(matchSwapMove);
                continue block0;
            }
        }
    }

    @Override
    public List<Move> createMoveList(Solution solution) {
        TravelingTournament travelingTournament = (TravelingTournament)solution;
        ArrayList<Move> moveList = new ArrayList<Move>();
        moveList.addAll(this.cachedMoveList);
        RotationMovesFactory rotationMovesFactory = new RotationMovesFactory(travelingTournament);
        this.logger.trace("Reused {} moves for N1 neighborhood.", (Object)moveList.size());
        int oldSize = moveList.size();
        rotationMovesFactory.addDayRotation(moveList);
        this.logger.trace("Created {} moves for N3 U N5 neighborhood.", (Object)(moveList.size() - oldSize));
        oldSize = moveList.size();
        rotationMovesFactory.addTeamRotation(moveList);
        this.logger.trace("Created {} moves for N2 U N4 neighborhood.", (Object)(moveList.size() - oldSize));
        rotationMovesFactory = null;
        return moveList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RotationMovesFactory {
        private List<Day> dayList;
        private List<Team> teamList;
        private List<Match> matchList;
        private Map<Day, Map<Team, Match>> dayTeamMap;
        private Map<Team, Map<Day, Match>> teamDayMap;
        private Map<Team, Map<Team, Match>> homeTeamAwayTeamMap;

        public RotationMovesFactory(TravelingTournament travelingTournament) {
            this.dayList = travelingTournament.getDayList();
            this.teamList = travelingTournament.getTeamList();
            this.matchList = travelingTournament.getMatchList();
            this.createMaps();
        }

        private void createMaps() {
            this.dayTeamMap = new HashMap<Day, Map<Team, Match>>(this.dayList.size());
            for (Day day : this.dayList) {
                this.dayTeamMap.put(day, new LinkedHashMap(this.teamList.size()));
            }
            this.teamDayMap = new HashMap<Team, Map<Day, Match>>(this.teamList.size());
            this.homeTeamAwayTeamMap = new HashMap<Team, Map<Team, Match>>(this.teamList.size());
            for (Team team : this.teamList) {
                this.teamDayMap.put(team, new LinkedHashMap(this.dayList.size()));
                this.homeTeamAwayTeamMap.put(team, new LinkedHashMap(this.teamList.size() - 1));
            }
            for (Match match : this.matchList) {
                Map<Team, Match> subTeamMap = this.dayTeamMap.get(match.getDay());
                subTeamMap.put(match.getHomeTeam(), match);
                subTeamMap.put(match.getAwayTeam(), match);
                this.teamDayMap.get(match.getHomeTeam()).put(match.getDay(), match);
                this.teamDayMap.get(match.getAwayTeam()).put(match.getDay(), match);
                this.homeTeamAwayTeamMap.get(match.getHomeTeam()).put(match.getAwayTeam(), match);
            }
        }

        private Team getOtherTeam(Match match, Team team) {
            return match.getHomeTeam().equals(team) ? match.getAwayTeam() : match.getHomeTeam();
        }

        private void addDayRotation(List<Move> moveList) {
            ListIterator<Day> firstDayIt = this.dayList.listIterator();
            while (firstDayIt.hasNext()) {
                Day firstDay = firstDayIt.next();
                Map<Team, Match> firstDayTeamMap = this.dayTeamMap.get(firstDay);
                ListIterator<Day> secondDayIt = this.dayList.listIterator(firstDayIt.nextIndex());
                while (secondDayIt.hasNext()) {
                    Day secondDay = secondDayIt.next();
                    ArrayList<Match> clonedFirstDayMatchList = new ArrayList<Match>(firstDayTeamMap.values());
                    while (!clonedFirstDayMatchList.isEmpty()) {
                        ArrayList<Match> rotateList = new ArrayList<Match>(4);
                        Match startMatch = (Match)clonedFirstDayMatchList.remove(0);
                        boolean otherInFirst = false;
                        rotateList.add(startMatch);
                        Team startHomeTeam = startMatch.getHomeTeam();
                        Team nextTeamToFind = startMatch.getAwayTeam();
                        while (!startHomeTeam.equals(nextTeamToFind)) {
                            Map<Team, Match> subTeamMap = this.dayTeamMap.get(otherInFirst ? firstDay : secondDay);
                            Match repairMatch = subTeamMap.get(nextTeamToFind);
                            if (otherInFirst) {
                                clonedFirstDayMatchList.remove(repairMatch);
                            }
                            rotateList.add(repairMatch);
                            nextTeamToFind = this.getOtherTeam(repairMatch, nextTeamToFind);
                            otherInFirst = !otherInFirst;
                        }
                        if (rotateList.size() <= 2) continue;
                        List<Match> emptyList = Collections.emptyList();
                        MultipleMatchListRotateMove rotateMove = new MultipleMatchListRotateMove(rotateList, emptyList);
                        moveList.add(rotateMove);
                    }
                }
            }
        }

        private void addTeamRotation(List<Move> moveList) {
            ListIterator<Team> firstTeamIt = this.teamList.listIterator();
            while (firstTeamIt.hasNext()) {
                Team firstTeam = firstTeamIt.next();
                Map<Day, Match> firstTeamDayMap = this.teamDayMap.get(firstTeam);
                ListIterator<Team> secondTeamIt = this.teamList.listIterator(firstTeamIt.nextIndex());
                block1: while (secondTeamIt.hasNext()) {
                    Team secondTeam = secondTeamIt.next();
                    ArrayList<Match> clonedFirstTeamMatchList = new ArrayList<Match>(firstTeamDayMap.values());
                    while (!clonedFirstTeamMatchList.isEmpty()) {
                        ArrayList<Match> firstRotateList = new ArrayList<Match>();
                        ArrayList<Match> secondRotateList = new ArrayList<Match>();
                        Match firstStartMatch = (Match)clonedFirstTeamMatchList.remove(0);
                        Team firstStartTeam = this.getOtherTeam(firstStartMatch, firstTeam);
                        Day startDay = firstStartMatch.getDay();
                        boolean firstTeamIsHomeTeam = firstStartMatch.getHomeTeam().equals(firstTeam);
                        Match secondStartMatch = this.teamDayMap.get(secondTeam).get(startDay);
                        if (firstStartMatch.equals(secondStartMatch)) continue block1;
                        firstRotateList.add(0, firstStartMatch);
                        secondRotateList.add(secondStartMatch);
                        HashMap<Team, Match> visitedTeamMap = new HashMap<Team, Match>();
                        Team teamToFind = this.getOtherTeam(secondStartMatch, secondTeam);
                        while (!teamToFind.equals(firstStartTeam)) {
                            Match firstRepairMatch = this.homeTeamAwayTeamMap.get(firstTeamIsHomeTeam ? firstTeam : teamToFind).get(firstTeamIsHomeTeam ? teamToFind : firstTeam);
                            if (!clonedFirstTeamMatchList.contains(firstRepairMatch)) {
                                if (visitedTeamMap.containsKey(teamToFind)) {
                                    Match shortcutMatch = (Match)visitedTeamMap.get(teamToFind);
                                    int shortcutSize = firstRotateList.indexOf(shortcutMatch) + 1;
                                    int reverseShortcutSize = firstRotateList.size() - shortcutSize;
                                    ArrayList<Match> firstShortcutRotateList = new ArrayList<Match>(firstRotateList.subList(0, shortcutSize));
                                    for (Match match : firstShortcutRotateList) {
                                        visitedTeamMap.remove(this.getOtherTeam(match, firstTeam));
                                    }
                                    ArrayList<Match> secondShortcutRotateList = new ArrayList<Match>(secondRotateList.subList(reverseShortcutSize, secondRotateList.size()));
                                    firstRotateList = new ArrayList(firstRotateList.subList(shortcutSize, firstRotateList.size()));
                                    secondRotateList = new ArrayList(secondRotateList.subList(0, reverseShortcutSize));
                                    this.addTeamRotateMove(moveList, firstShortcutRotateList, secondShortcutRotateList);
                                }
                                firstTeamIsHomeTeam = !firstTeamIsHomeTeam;
                                firstRepairMatch = this.homeTeamAwayTeamMap.get(firstTeamIsHomeTeam ? firstTeam : teamToFind).get(firstTeamIsHomeTeam ? teamToFind : firstTeam);
                            }
                            Day repairDay = firstRepairMatch.getDay();
                            Match secondRepairMatch = this.teamDayMap.get(secondTeam).get(repairDay);
                            clonedFirstTeamMatchList.remove(firstRepairMatch);
                            visitedTeamMap.put(teamToFind, firstRepairMatch);
                            firstRotateList.add(0, firstRepairMatch);
                            secondRotateList.add(secondRepairMatch);
                            teamToFind = this.getOtherTeam(secondRepairMatch, secondTeam);
                        }
                        this.addTeamRotateMove(moveList, firstRotateList, secondRotateList);
                    }
                }
            }
        }

        private void addTeamRotateMove(List<Move> moveList, List<Match> firstRotateList, List<Match> secondRotateList) {
            assert (firstRotateList.size() == secondRotateList.size());
            if (firstRotateList.size() > 2) {
                MultipleMatchListRotateMove rotateMove = new MultipleMatchListRotateMove(firstRotateList, secondRotateList);
                moveList.add(rotateMove);
            }
        }
    }
}

