/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.config.heuristic.selector.move.generic;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Collection;
import org.drools.planner.config.EnvironmentMode;
import org.drools.planner.config.heuristic.selector.common.SelectionOrder;
import org.drools.planner.config.heuristic.selector.entity.EntitySelectorConfig;
import org.drools.planner.config.heuristic.selector.move.MoveSelectorConfig;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.generic.SwapMoveSelector;

@XStreamAlias(value="swapMoveSelector")
public class SwapMoveSelectorConfig
extends MoveSelectorConfig {
    @XStreamAlias(value="entitySelector")
    private EntitySelectorConfig entitySelectorConfig = new EntitySelectorConfig();
    @XStreamAlias(value="secondaryEntitySelector")
    private EntitySelectorConfig secondaryEntitySelectorConfig = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    public EntitySelectorConfig getSecondaryEntitySelectorConfig() {
        return this.secondaryEntitySelectorConfig;
    }

    public void setSecondaryEntitySelectorConfig(EntitySelectorConfig secondaryEntitySelectorConfig) {
        this.secondaryEntitySelectorConfig = secondaryEntitySelectorConfig;
    }

    public MoveSelector buildBaseMoveSelector(EnvironmentMode environmentMode, SolutionDescriptor solutionDescriptor, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder) {
        EntitySelector leftEntitySelector = this.entitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, resolvedSelectionOrder);
        EntitySelectorConfig rightEntitySelectorConfig = this.secondaryEntitySelectorConfig == null ? this.entitySelectorConfig : this.secondaryEntitySelectorConfig;
        EntitySelector rightEntitySelector = rightEntitySelectorConfig.buildEntitySelector(environmentMode, solutionDescriptor, minimumCacheType, resolvedSelectionOrder);
        Collection<PlanningVariableDescriptor> variableDescriptors = leftEntitySelector.getEntityDescriptor().getPlanningVariableDescriptors();
        return new SwapMoveSelector(leftEntitySelector, rightEntitySelector, variableDescriptors, resolvedSelectionOrder == SelectionOrder.RANDOM);
    }

    public void inherit(SwapMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.entitySelectorConfig == null) {
            this.entitySelectorConfig = inheritedConfig.getEntitySelectorConfig();
        } else if (inheritedConfig.getEntitySelectorConfig() != null) {
            this.entitySelectorConfig.inherit(inheritedConfig.getEntitySelectorConfig());
        }
        if (this.secondaryEntitySelectorConfig == null) {
            this.secondaryEntitySelectorConfig = inheritedConfig.getSecondaryEntitySelectorConfig();
        } else if (inheritedConfig.getSecondaryEntitySelectorConfig() != null) {
            this.secondaryEntitySelectorConfig.inherit(inheritedConfig.getSecondaryEntitySelectorConfig());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + (this.secondaryEntitySelectorConfig == null ? "" : ", " + this.secondaryEntitySelectorConfig) + ")";
    }
}

