/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.bruteforce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.planner.core.bruteforce.BruteForceSolverPhaseScope;
import org.drools.planner.core.bruteforce.BruteForceStepScope;
import org.drools.planner.core.bruteforce.event.BruteForceSolverPhaseLifecycleListener;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.solution.SolutionDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionOrder;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelectionPromotion;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueSelector;
import org.drools.planner.core.heuristic.selector.variable.PlanningValueWalker;
import org.drools.planner.core.heuristic.selector.variable.PlanningVariableWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceEntityWalker
implements BruteForceSolverPhaseLifecycleListener {
    private SolutionDescriptor solutionDescriptor;
    private List<PlanningVariableWalker> planningVariableWalkerList;

    public BruteForceEntityWalker(SolutionDescriptor solutionDescriptor) {
        this.solutionDescriptor = solutionDescriptor;
    }

    @Override
    public void phaseStarted(BruteForceSolverPhaseScope bruteForceSolverPhaseScope) {
        List<Object> workingPlanningEntityList = bruteForceSolverPhaseScope.getWorkingPlanningEntityList();
        this.planningVariableWalkerList = new ArrayList<PlanningVariableWalker>(workingPlanningEntityList.size());
        for (Object planningEntity : workingPlanningEntityList) {
            PlanningEntityDescriptor planningEntityDescriptor = this.solutionDescriptor.getPlanningEntityDescriptor(planningEntity.getClass());
            PlanningVariableWalker planningVariableWalker = new PlanningVariableWalker(planningEntityDescriptor);
            List<PlanningValueWalker> planningValueWalkerList = this.buildPlanningValueWalkerList(planningEntityDescriptor);
            planningVariableWalker.setPlanningValueWalkerList(planningValueWalkerList);
            this.planningVariableWalkerList.add(planningVariableWalker);
            planningVariableWalker.phaseStarted(bruteForceSolverPhaseScope);
            planningVariableWalker.initWalk(planningEntity);
        }
    }

    private List<PlanningValueWalker> buildPlanningValueWalkerList(PlanningEntityDescriptor planningEntityDescriptor) {
        Collection<PlanningVariableDescriptor> planningVariableDescriptors = planningEntityDescriptor.getPlanningVariableDescriptors();
        ArrayList<PlanningValueWalker> planningValueWalkerList = new ArrayList<PlanningValueWalker>(planningVariableDescriptors.size());
        for (PlanningVariableDescriptor planningVariableDescriptor : planningVariableDescriptors) {
            PlanningValueSelector planningValueSelector = new PlanningValueSelector(planningVariableDescriptor);
            planningValueSelector.setSelectionOrder(PlanningValueSelectionOrder.ORIGINAL);
            planningValueSelector.setSelectionPromotion(PlanningValueSelectionPromotion.NONE);
            planningValueSelector.setRoundRobinSelection(false);
            PlanningValueWalker planningValueWalker = new PlanningValueWalker(planningVariableDescriptor, planningValueSelector);
            planningValueWalkerList.add(planningValueWalker);
        }
        return planningValueWalkerList;
    }

    public boolean hasWalk() {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            if (!planningVariableWalker.hasWalk()) continue;
            return true;
        }
        return false;
    }

    public void walk() {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            if (planningVariableWalker.hasWalk()) {
                planningVariableWalker.walk();
                break;
            }
            planningVariableWalker.resetWalk();
        }
    }

    @Override
    public void stepEnded(BruteForceStepScope bruteForceStepScope) {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            planningVariableWalker.stepEnded(bruteForceStepScope);
        }
    }

    @Override
    public void phaseEnded(BruteForceSolverPhaseScope bruteForceSolverPhaseScope) {
        for (PlanningVariableWalker planningVariableWalker : this.planningVariableWalkerList) {
            planningVariableWalker.phaseEnded(bruteForceSolverPhaseScope);
        }
        this.planningVariableWalkerList = null;
    }
}

