/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.domain.solution;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.planner.api.domain.solution.PlanningEntityCollectionProperty;
import org.drools.planner.api.domain.solution.PlanningEntityProperty;
import org.drools.planner.core.domain.common.DescriptorUtils;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.solution.Solution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionDescriptor {
    private final Class<? extends Solution> solutionClass;
    private final BeanInfo solutionBeanInfo;
    private final Map<String, PropertyDescriptor> propertyDescriptorMap;
    private final Map<String, PropertyDescriptor> entityPropertyDescriptorMap;
    private final Map<String, PropertyDescriptor> entityCollectionPropertyDescriptorMap;
    private final Map<Class<?>, PlanningEntityDescriptor> planningEntityDescriptorMap;

    public SolutionDescriptor(Class<? extends Solution> solutionClass) {
        this.solutionClass = solutionClass;
        try {
            this.solutionBeanInfo = Introspector.getBeanInfo(solutionClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("The solutionClass (" + solutionClass + ") is not a valid java bean.", e);
        }
        int mapSize = this.solutionBeanInfo.getPropertyDescriptors().length;
        this.propertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.entityPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.entityCollectionPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>(mapSize);
        this.planningEntityDescriptorMap = new HashMap(mapSize);
    }

    public void processAnnotations() {
        this.processPropertyAnnotations();
    }

    private void processPropertyAnnotations() {
        boolean noPlanningEntityPropertyAnnotation = true;
        for (PropertyDescriptor propertyDescriptor : this.solutionBeanInfo.getPropertyDescriptors()) {
            this.propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            Method propertyGetter = propertyDescriptor.getReadMethod();
            if (propertyGetter == null) continue;
            if (propertyGetter.isAnnotationPresent(PlanningEntityProperty.class)) {
                noPlanningEntityPropertyAnnotation = false;
                this.entityPropertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                continue;
            }
            if (!propertyGetter.isAnnotationPresent(PlanningEntityCollectionProperty.class)) continue;
            noPlanningEntityPropertyAnnotation = false;
            if (!Collection.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") has a PlanningEntityCollection annotated property (" + propertyDescriptor.getName() + ") that does not return a Collection.");
            }
            this.entityCollectionPropertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        if (noPlanningEntityPropertyAnnotation) {
            throw new IllegalStateException("The solutionClass (" + this.solutionClass + ") should have at least 1 getter with a PlanningEntityCollection or PlanningEntityProperty" + " annotation.");
        }
    }

    public void addPlanningEntityDescriptor(PlanningEntityDescriptor planningEntityDescriptor) {
        this.planningEntityDescriptorMap.put(planningEntityDescriptor.getPlanningEntityClass(), planningEntityDescriptor);
    }

    public Class<? extends Solution> getSolutionClass() {
        return this.solutionClass;
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    public Set<Class<?>> getPlanningEntityClassSet() {
        return this.planningEntityDescriptorMap.keySet();
    }

    public Collection<PlanningEntityDescriptor> getPlanningEntityDescriptors() {
        return this.planningEntityDescriptorMap.values();
    }

    public boolean hasPlanningEntityDescriptorStrict(Class<?> planningEntityClass) {
        return this.planningEntityDescriptorMap.containsKey(planningEntityClass);
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptorStrict(Class<?> planningEntityClass) {
        return this.planningEntityDescriptorMap.get(planningEntityClass);
    }

    public boolean hasPlanningEntityDescriptor(Class<?> planningEntitySubclass) {
        PlanningEntityDescriptor planningEntityDescriptor = null;
        for (Class<?> planningEntityClass = planningEntitySubclass; planningEntityClass != null; planningEntityClass = planningEntityClass.getSuperclass()) {
            planningEntityDescriptor = this.planningEntityDescriptorMap.get(planningEntityClass);
            if (planningEntityDescriptor == null) continue;
            return true;
        }
        return false;
    }

    public PlanningEntityDescriptor getPlanningEntityDescriptor(Class<?> planningEntitySubclass) {
        PlanningEntityDescriptor planningEntityDescriptor = null;
        for (Class<?> planningEntityClass = planningEntitySubclass; planningEntityClass != null; planningEntityClass = planningEntityClass.getSuperclass()) {
            planningEntityDescriptor = this.planningEntityDescriptorMap.get(planningEntityClass);
            if (planningEntityDescriptor == null) continue;
            return planningEntityDescriptor;
        }
        throw new IllegalArgumentException("A planningEntity is an instance of a planningEntitySubclass (" + planningEntitySubclass + ") that is not configured as a planningEntity.\n" + "If that class (" + planningEntitySubclass.getSimpleName() + ") (or superclass thereof) is not a " + "planningEntityClass (" + this.getPlanningEntityClassSet() + "), check your Solution implementation's annotated methods.\n" + "If it is, check your solver configuration.");
    }

    public Collection<PlanningVariableDescriptor> getChainedVariableDescriptors() {
        ArrayList<PlanningVariableDescriptor> chainedVariableDescriptors = new ArrayList<PlanningVariableDescriptor>();
        for (PlanningEntityDescriptor entityDescriptor : this.planningEntityDescriptorMap.values()) {
            for (PlanningVariableDescriptor variableDescriptor : entityDescriptor.getPlanningVariableDescriptors()) {
                if (!variableDescriptor.isChained()) continue;
                chainedVariableDescriptors.add(variableDescriptor);
            }
        }
        return chainedVariableDescriptors;
    }

    public Collection<Object> getAllFacts(Solution solution) {
        ArrayList<Object> facts = new ArrayList<Object>();
        facts.addAll(solution.getProblemFacts());
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            PlanningEntityDescriptor planningEntityDescriptor;
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            if (entity == null || !(planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass())).isInitialized(entity)) continue;
            facts.add(entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
                if (!planningEntityDescriptor.isInitialized(entity)) continue;
                facts.add(entity);
            }
        }
        return facts;
    }

    public List<Object> getPlanningEntityList(Solution solution) {
        ArrayList<Object> planningEntityList = new ArrayList<Object>();
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            if (entity == null) continue;
            planningEntityList.add(entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            planningEntityList.addAll(entityCollection);
        }
        return planningEntityList;
    }

    public List<Object> getPlanningEntityListByPlanningEntityClass(Solution solution, Class<?> planningEntityClass) {
        ArrayList<Object> planningEntityList = new ArrayList<Object>();
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity;
            if (!entityPropertyDescriptor.getPropertyType().isAssignableFrom(planningEntityClass) || (entity = this.extractPlanningEntity(entityPropertyDescriptor, solution)) == null || !planningEntityClass.isInstance(entity)) continue;
            planningEntityList.add(entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                if (!planningEntityClass.isInstance(entity)) continue;
                planningEntityList.add(entity);
            }
        }
        return planningEntityList;
    }

    public int getPlanningEntityCount(Solution solution) {
        return this.getPlanningEntityList(solution).size();
    }

    public long getProblemScale(Solution solution) {
        long problemScale = 0L;
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            if (entity == null) continue;
            PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
            problemScale += planningEntityDescriptor.getProblemScale(solution, entity);
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
                problemScale += planningEntityDescriptor.getProblemScale(solution, entity);
            }
        }
        return problemScale;
    }

    public boolean isInitialized(Solution solution) {
        for (PropertyDescriptor entityPropertyDescriptor : this.entityPropertyDescriptorMap.values()) {
            Object entity = this.extractPlanningEntity(entityPropertyDescriptor, solution);
            if (entity == null) {
                return false;
            }
            PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
            if (planningEntityDescriptor.isInitialized(entity)) continue;
            return false;
        }
        for (PropertyDescriptor entityCollectionPropertyDescriptor : this.entityCollectionPropertyDescriptorMap.values()) {
            Collection<?> entityCollection = this.extractPlanningEntityCollection(entityCollectionPropertyDescriptor, solution);
            for (Object entity : entityCollection) {
                PlanningEntityDescriptor planningEntityDescriptor = this.getPlanningEntityDescriptor(entity.getClass());
                if (planningEntityDescriptor.isInitialized(entity)) continue;
                return false;
            }
        }
        return true;
    }

    private Object extractPlanningEntity(PropertyDescriptor entityPropertyDescriptor, Solution solution) {
        return DescriptorUtils.executeGetter(entityPropertyDescriptor, solution);
    }

    private Collection<?> extractPlanningEntityCollection(PropertyDescriptor entityCollectionPropertyDescriptor, Solution solution) {
        Collection entityCollection = (Collection)DescriptorUtils.executeGetter(entityCollectionPropertyDescriptor, solution);
        if (entityCollection == null) {
            throw new IllegalArgumentException("The solutionClass (" + this.solutionClass + ")'s entityCollectionProperty (" + entityCollectionPropertyDescriptor.getName() + ") should never return null.");
        }
        return entityCollection;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.solutionClass.getName() + ")";
    }
}

