/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector;

import java.util.Random;
import org.drools.planner.core.heuristic.selector.Selector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleSupport;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelector
implements Selector {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SolverPhaseLifecycleSupport solverPhaseLifecycleSupport = new SolverPhaseLifecycleSupport();
    protected Random workingRandom = null;

    public void solvingStarted(DefaultSolverScope solverScope) {
        this.workingRandom = solverScope.getWorkingRandom();
        this.solverPhaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        this.solverPhaseLifecycleSupport.firePhaseStarted(solverPhaseScope);
    }

    public void stepStarted(AbstractStepScope stepScope) {
        this.solverPhaseLifecycleSupport.fireStepStarted(stepScope);
    }

    public void stepEnded(AbstractStepScope stepScope) {
        this.solverPhaseLifecycleSupport.fireStepEnded(stepScope);
    }

    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.solverPhaseLifecycleSupport.firePhaseEnded(solverPhaseScope);
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        this.solverPhaseLifecycleSupport.fireSolvingEnded(solverScope);
        this.workingRandom = null;
    }
}

