/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.entity.decorator;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.drools.planner.core.domain.entity.PlanningEntityDescriptor;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionFilter;
import org.drools.planner.core.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.drools.planner.core.heuristic.selector.entity.AbstractEntitySelector;
import org.drools.planner.core.heuristic.selector.entity.EntitySelector;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.score.director.ScoreDirector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringEntitySelector
extends AbstractEntitySelector {
    protected final EntitySelector childEntitySelector;
    protected final List<SelectionFilter> entityFilterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector scoreDirector = null;

    public FilteringEntitySelector(EntitySelector childEntitySelector, List<SelectionFilter> entityFilterList) {
        this.childEntitySelector = childEntitySelector;
        this.entityFilterList = entityFilterList;
        this.bailOutEnabled = childEntitySelector.isNeverEnding();
        this.solverPhaseLifecycleSupport.addEventListener(childEntitySelector);
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseStarted(solverPhaseScope);
        this.scoreDirector = solverPhaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        super.phaseEnded(solverPhaseScope);
        this.scoreDirector = null;
    }

    @Override
    public PlanningEntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isContinuous() {
        return this.childEntitySelector.isContinuous();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childEntitySelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize();
    }

    @Override
    public Iterator<Object> iterator() {
        return new JustInTimeFilteringEntityIterator(this.childEntitySelector.iterator());
    }

    protected long determineBailOutSize() {
        return this.childEntitySelector.getSize() * 10L;
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    private boolean accept(ScoreDirector scoreDirector, Object entity) {
        for (SelectionFilter entityFilter : this.entityFilterList) {
            if (entityFilter.accept(scoreDirector, entity)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childEntitySelector + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JustInTimeFilteringEntityIterator
    extends UpcomingSelectionIterator<Object> {
        private final Iterator<Object> childEntityIterator;

        public JustInTimeFilteringEntityIterator(Iterator<Object> childEntityIterator) {
            this.childEntityIterator = childEntityIterator;
            this.createUpcomingSelection();
        }

        @Override
        protected void createUpcomingSelection() {
            Object next;
            long attemptsBeforeBailOut;
            long l = attemptsBeforeBailOut = FilteringEntitySelector.this.bailOutEnabled ? FilteringEntitySelector.this.determineBailOutSize() : 0L;
            do {
                if (!this.childEntityIterator.hasNext()) {
                    next = null;
                    break;
                }
                if (!FilteringEntitySelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringEntitySelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringEntitySelector.this);
                    next = null;
                    break;
                }
                --attemptsBeforeBailOut;
            } while (!FilteringEntitySelector.this.accept(FilteringEntitySelector.this.scoreDirector, next = this.childEntityIterator.next()));
            this.upcomingSelection = next;
        }
    }
}

