/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.commons.collections.iterators.IteratorChain;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.heuristic.selector.move.composite.CompositeMoveSelector;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.util.RandomUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMoveSelector
extends CompositeMoveSelector {
    protected final SelectionProbabilityWeightFactory selectorProbabilityWeightFactory;
    protected ScoreDirector scoreDirector;

    public UnionMoveSelector(List<MoveSelector> childMoveSelectorList, boolean randomSelection) {
        this(childMoveSelectorList, randomSelection, null);
    }

    public UnionMoveSelector(List<MoveSelector> childMoveSelectorList, boolean randomSelection, SelectionProbabilityWeightFactory selectorProbabilityWeightFactory) {
        super(childMoveSelectorList, randomSelection);
        this.selectorProbabilityWeightFactory = selectorProbabilityWeightFactory;
        if (!randomSelection) {
            if (selectorProbabilityWeightFactory != null) {
                throw new IllegalArgumentException("The selector (" + this + ") with randomSelection (" + randomSelection + ") cannot have a selectorProbabilityWeightFactory (" + selectorProbabilityWeightFactory + ").");
            }
        } else if (selectorProbabilityWeightFactory == null) {
            throw new IllegalArgumentException("The selector (" + this + ") with randomSelection (" + randomSelection + ") requires a selectorProbabilityWeightFactory (" + selectorProbabilityWeightFactory + ").");
        }
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        this.scoreDirector = stepScope.getScoreDirector();
        super.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        super.stepEnded(stepScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isNeverEnding() {
        if (this.randomSelection) {
            for (MoveSelector moveSelector : this.childMoveSelectorList) {
                if (!moveSelector.isNeverEnding()) continue;
                return true;
            }
            return false;
        }
        return !this.childMoveSelectorList.isEmpty() && ((MoveSelector)this.childMoveSelectorList.get(this.childMoveSelectorList.size() - 1)).isNeverEnding();
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (MoveSelector moveSelector : this.childMoveSelectorList) {
            size += moveSelector.getSize();
        }
        return size;
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            ArrayList iteratorList = new ArrayList(this.childMoveSelectorList.size());
            for (MoveSelector moveSelector : this.childMoveSelectorList) {
                iteratorList.add(moveSelector.iterator());
            }
            return new IteratorChain(iteratorList);
        }
        return new RandomUnionMoveIterator();
    }

    @Override
    public String toString() {
        return "Union(" + this.childMoveSelectorList + ")";
    }

    private static class ProbabilityItem {
        protected MoveSelector moveSelector;
        protected Iterator<Move> moveIterator;
        protected double probabilityWeight;

        private ProbabilityItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RandomUnionMoveIterator
    implements Iterator<Move> {
        protected final NavigableMap<Double, Iterator<Move>> moveIteratorMap = new TreeMap<Double, Iterator<Move>>();
        protected final Map<Iterator<Move>, ProbabilityItem> probabilityItemMap;
        protected double probabilityWeightTotal;

        public RandomUnionMoveIterator() {
            this.probabilityItemMap = new LinkedHashMap<Iterator<Move>, ProbabilityItem>(UnionMoveSelector.this.childMoveSelectorList.size());
            for (MoveSelector moveSelector : UnionMoveSelector.this.childMoveSelectorList) {
                Iterator moveIterator = moveSelector.iterator();
                if (!moveIterator.hasNext()) continue;
                ProbabilityItem probabilityItem = new ProbabilityItem();
                probabilityItem.moveSelector = moveSelector;
                probabilityItem.moveIterator = moveIterator;
                probabilityItem.probabilityWeight = UnionMoveSelector.this.selectorProbabilityWeightFactory.createProbabilityWeight(UnionMoveSelector.this.scoreDirector, moveSelector);
                this.probabilityItemMap.put(moveIterator, probabilityItem);
            }
            this.refreshMoveIteratorMap();
        }

        @Override
        public boolean hasNext() {
            return !this.moveIteratorMap.isEmpty();
        }

        @Override
        public Move next() {
            double randomOffset = RandomUtils.nextDouble(UnionMoveSelector.this.workingRandom, this.probabilityWeightTotal);
            Map.Entry<Double, Iterator<Move>> entry = this.moveIteratorMap.floorEntry(randomOffset);
            Iterator<Move> moveIterator = entry.getValue();
            Move next = moveIterator.next();
            if (!moveIterator.hasNext()) {
                this.probabilityItemMap.remove(moveIterator);
                this.refreshMoveIteratorMap();
            }
            return next;
        }

        private void refreshMoveIteratorMap() {
            this.moveIteratorMap.clear();
            double probabilityWeightOffset = 0.0;
            for (ProbabilityItem probabilityItem : this.probabilityItemMap.values()) {
                this.moveIteratorMap.put(probabilityWeightOffset, probabilityItem.moveIterator);
                probabilityWeightOffset += probabilityItem.probabilityWeight;
            }
            this.probabilityWeightTotal = probabilityWeightOffset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported.");
        }
    }
}

