/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.move.factory;

import java.util.Iterator;
import java.util.List;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.iterator.CachedListRandomIterator;
import org.drools.planner.core.heuristic.selector.move.AbstractMoveSelector;
import org.drools.planner.core.heuristic.selector.move.factory.MoveListFactory;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.solver.DefaultSolverScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveListFactoryToMoveSelectorBridge
extends AbstractMoveSelector
implements SelectionCacheLifecycleListener {
    protected final MoveListFactory moveListFactory;
    protected final SelectionCacheType cacheType;
    protected final boolean randomSelection;
    protected List<Move> cachedMoveList = null;

    public MoveListFactoryToMoveSelectorBridge(MoveListFactory moveListFactory, SelectionCacheType cacheType, boolean randomSelection) {
        this.moveListFactory = moveListFactory;
        this.cacheType = cacheType;
        this.randomSelection = randomSelection;
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public void constructCache(DefaultSolverScope solverScope) {
        this.cachedMoveList = this.moveListFactory.createMoveList(solverScope.getScoreDirector().getWorkingSolution());
        this.logger.trace("    Created cachedMoveList with size ({}) in moveSelector({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public void disposeCache(DefaultSolverScope solverScope) {
        this.cachedMoveList = null;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedMoveList.size();
    }

    @Override
    public Iterator<Move> iterator() {
        if (!this.randomSelection) {
            return this.cachedMoveList.iterator();
        }
        return new CachedListRandomIterator<Move>(this.cachedMoveList, this.workingRandom);
    }

    public String toString() {
        return "MoveListFactory(" + this.moveListFactory.getClass() + ")";
    }
}

