/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.heuristic.selector.value.decorator;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.drools.planner.core.domain.variable.PlanningVariableDescriptor;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleBridge;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheLifecycleListener;
import org.drools.planner.core.heuristic.selector.common.SelectionCacheType;
import org.drools.planner.core.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import org.drools.planner.core.heuristic.selector.value.AbstractValueSelector;
import org.drools.planner.core.heuristic.selector.value.ValueSelector;
import org.drools.planner.core.heuristic.selector.value.iterator.EntityIgnoringValueIterator;
import org.drools.planner.core.heuristic.selector.value.iterator.ValueIterator;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.util.RandomUtils;

public class ProbabilityValueSelector
extends AbstractValueSelector
implements SelectionCacheLifecycleListener {
    protected final ValueSelector childValueSelector;
    protected final SelectionCacheType cacheType;
    protected final SelectionProbabilityWeightFactory valueProbabilityWeightFactory;
    protected NavigableMap<Double, Object> cachedEntityMap = null;
    protected double probabilityWeightTotal = -1.0;

    public ProbabilityValueSelector(ValueSelector childValueSelector, SelectionCacheType cacheType, SelectionProbabilityWeightFactory valueProbabilityWeightFactory) {
        this.childValueSelector = childValueSelector;
        this.cacheType = cacheType;
        this.valueProbabilityWeightFactory = valueProbabilityWeightFactory;
        if (childValueSelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has a childValueSelector (" + childValueSelector + ") with neverEnding (" + childValueSelector.isNeverEnding() + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(childValueSelector);
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + (Object)((Object)cacheType) + ").");
        }
        this.solverPhaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    public void constructCache(DefaultSolverScope solverScope) {
        this.cachedEntityMap = new TreeMap<Double, Object>();
        ScoreDirector scoreDirector = solverScope.getScoreDirector();
        double probabilityWeightOffset = 0.0;
        for (Object value : this.childValueSelector) {
            double probabilityWeight = this.valueProbabilityWeightFactory.createProbabilityWeight(scoreDirector, value);
            this.cachedEntityMap.put(probabilityWeightOffset, value);
            probabilityWeightOffset += probabilityWeight;
        }
        this.probabilityWeightTotal = probabilityWeightOffset;
    }

    public void disposeCache(DefaultSolverScope solverScope) {
        this.probabilityWeightTotal = -1.0;
    }

    public PlanningVariableDescriptor getVariableDescriptor() {
        return this.childValueSelector.getVariableDescriptor();
    }

    public boolean isContinuous() {
        return false;
    }

    public boolean isNeverEnding() {
        return false;
    }

    public long getSize() {
        return this.cachedEntityMap.size();
    }

    public ValueIterator iterator() {
        return new EntityIgnoringValueIterator(){

            public boolean hasNext() {
                return true;
            }

            public Object next() {
                double randomOffset = RandomUtils.nextDouble(ProbabilityValueSelector.this.workingRandom, ProbabilityValueSelector.this.probabilityWeightTotal);
                Map.Entry<Double, Object> entry = ProbabilityValueSelector.this.cachedEntityMap.floorEntry(randomOffset);
                return entry.getValue();
            }
        };
    }

    public String toString() {
        return "Probability(" + this.childValueSelector + ")";
    }
}

