/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch;

import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.event.LocalSearchSolverPhaseLifecycleListener;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.phase.AbstractSolverPhase;
import org.drools.planner.core.solver.DefaultSolverScope;

public class DefaultLocalSearchSolverPhase
extends AbstractSolverPhase
implements LocalSearchSolverPhase,
LocalSearchSolverPhaseLifecycleListener {
    protected Decider decider;
    protected boolean assertStepScoreIsUncorrupted = false;

    public Decider getDecider() {
        return this.decider;
    }

    public void setDecider(Decider decider) {
        this.decider = decider;
        this.decider.setLocalSearchSolverPhase(this);
    }

    public void setAssertStepScoreIsUncorrupted(boolean assertStepScoreIsUncorrupted) {
        this.assertStepScoreIsUncorrupted = assertStepScoreIsUncorrupted;
    }

    public void solve(DefaultSolverScope solverScope) {
        LocalSearchSolverPhaseScope solverPhaseScope = new LocalSearchSolverPhaseScope(solverScope);
        this.phaseStarted(solverPhaseScope);
        LocalSearchStepScope stepScope = this.createNextStepScope(solverPhaseScope, null);
        while (!this.termination.isPhaseTerminated(solverPhaseScope)) {
            stepScope.setTimeGradient(this.termination.calculatePhaseTimeGradient(solverPhaseScope));
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope);
            Move nextStep = stepScope.getStep();
            if (nextStep == null) {
                if (this.termination.isPhaseTerminated(solverPhaseScope)) {
                    this.logger.trace("    Step index ({}), time spend ({}) terminated without picking a nextStep.", (Object)stepScope.getStepIndex(), (Object)stepScope.getLocalSearchSolverPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                if (stepScope.getSelectedMoveCount() == 0L) {
                    this.logger.warn("    No doable selected move at step index ({}), time spend ({}). Terminating phase early.", (Object)stepScope.getStepIndex(), (Object)stepScope.getLocalSearchSolverPhaseScope().calculateSolverTimeMillisSpend());
                    break;
                }
                throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has accepted/selected move count (" + stepScope.getAcceptedMoveCount() + "/" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + nextStep + ").");
            }
            nextStep.doMove(stepScope.getScoreDirector());
            solverPhaseScope.getWorkingSolution().setScore(stepScope.getScore());
            if (this.assertStepScoreIsUncorrupted) {
                solverPhaseScope.assertWorkingScore(stepScope.getScore());
            }
            this.stepEnded(stepScope);
            stepScope = this.createNextStepScope(solverPhaseScope, stepScope);
        }
        this.phaseEnded(solverPhaseScope);
    }

    private LocalSearchStepScope createNextStepScope(LocalSearchSolverPhaseScope localSearchSolverPhaseScope, LocalSearchStepScope completedLocalSearchStepScope) {
        if (completedLocalSearchStepScope == null) {
            completedLocalSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
            completedLocalSearchStepScope.setScore(localSearchSolverPhaseScope.getStartingScore());
            completedLocalSearchStepScope.setStepIndex(-1);
            completedLocalSearchStepScope.setTimeGradient(0.0);
        }
        localSearchSolverPhaseScope.setLastCompletedLocalSearchStepScope(completedLocalSearchStepScope);
        LocalSearchStepScope localSearchStepScope = new LocalSearchStepScope(localSearchSolverPhaseScope);
        localSearchStepScope.setStepIndex(completedLocalSearchStepScope.getStepIndex() + 1);
        localSearchStepScope.setSolutionInitialized(true);
        return localSearchStepScope;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        super.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.decider.phaseStarted(localSearchSolverPhaseScope);
        if (!localSearchSolverPhaseScope.isWorkingSolutionInitialized()) {
            throw new IllegalStateException("Phase localSearch started with an uninitialized Solution. First initialize the Solution. For example, run a phase constructionHeuristic first.");
        }
    }

    public void stepStarted(LocalSearchStepScope localSearchStepScope) {
        super.stepStarted(localSearchStepScope);
        this.decider.stepStarted(localSearchStepScope);
    }

    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        super.stepEnded(localSearchStepScope);
        this.decider.stepEnded(localSearchStepScope);
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = localSearchStepScope.getLocalSearchSolverPhaseScope();
        if (this.logger.isDebugEnabled()) {
            long timeMillisSpend = localSearchSolverPhaseScope.calculateSolverTimeMillisSpend();
            this.logger.debug("    Step index ({}), time spend ({}), score ({}), {} best score ({}), accepted/selected move count ({}/{}) for picked step ({}).", new Object[]{localSearchStepScope.getStepIndex(), timeMillisSpend, localSearchStepScope.getScore(), localSearchStepScope.getBestScoreImproved() != false ? "new" : "   ", localSearchSolverPhaseScope.getBestScore(), localSearchStepScope.getAcceptedMoveCount(), localSearchStepScope.getSelectedMoveCount(), localSearchStepScope.getStepString()});
        }
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.decider.phaseEnded(localSearchSolverPhaseScope);
        this.logger.info("Phase localSearch ended: step total ({}), time spend ({}), best score ({}).", new Object[]{localSearchSolverPhaseScope.getLastCompletedStepScope().getStepIndex() + 1, localSearchSolverPhaseScope.calculateSolverTimeMillisSpend(), localSearchSolverPhaseScope.getBestScore()});
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        super.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }
}

