/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider;

import org.drools.planner.core.heuristic.selector.move.MoveSelector;
import org.drools.planner.core.localsearch.LocalSearchSolverPhase;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.Decider;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.Acceptor;
import org.drools.planner.core.localsearch.decider.forager.Forager;
import org.drools.planner.core.move.Move;
import org.drools.planner.core.score.Score;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecider
implements Decider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected LocalSearchSolverPhase localSearchSolverPhase;
    protected Termination termination;
    protected MoveSelector moveSelector;
    protected Acceptor acceptor;
    protected Forager forager;
    protected boolean assertMoveScoreIsUncorrupted = false;
    protected boolean assertUndoMoveIsUncorrupted = false;

    public void setLocalSearchSolverPhase(LocalSearchSolverPhase localSearchSolverPhase) {
        this.localSearchSolverPhase = localSearchSolverPhase;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setMoveSelector(MoveSelector moveSelector) {
        this.moveSelector = moveSelector;
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public Forager getForager() {
        return this.forager;
    }

    public void setForager(Forager forager) {
        this.forager = forager;
    }

    public void setAssertMoveScoreIsUncorrupted(boolean assertMoveScoreIsUncorrupted) {
        this.assertMoveScoreIsUncorrupted = assertMoveScoreIsUncorrupted;
    }

    public void setAssertUndoMoveIsUncorrupted(boolean assertUndoMoveIsUncorrupted) {
        this.assertUndoMoveIsUncorrupted = assertUndoMoveIsUncorrupted;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        this.moveSelector.solvingStarted(solverScope);
        this.acceptor.solvingStarted(solverScope);
        this.forager.solvingStarted(solverScope);
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.moveSelector.phaseStarted(localSearchSolverPhaseScope);
        this.acceptor.phaseStarted(localSearchSolverPhaseScope);
        this.forager.phaseStarted(localSearchSolverPhaseScope);
    }

    public void stepStarted(LocalSearchStepScope localSearchStepScope) {
        this.moveSelector.stepStarted(localSearchStepScope);
        this.acceptor.stepStarted(localSearchStepScope);
        this.forager.stepStarted(localSearchStepScope);
    }

    public void decideNextStep(LocalSearchStepScope stepScope) {
        MoveScope pickedMoveScope;
        ScoreDirector scoreDirector = stepScope.getScoreDirector();
        int moveIndex = 0;
        for (Move move : this.moveSelector) {
            MoveScope moveScope = new MoveScope(stepScope);
            moveScope.setMoveIndex(moveIndex);
            moveScope.setMove(move);
            if (!move.isMoveDoable(scoreDirector)) {
                this.logger.trace("        Ignoring not doable move ({}).", (Object)move);
            } else {
                this.doMove(moveScope);
                if (this.forager.isQuitEarly()) break;
            }
            ++moveIndex;
            if (!this.termination.isPhaseTerminated(stepScope.getLocalSearchSolverPhaseScope())) continue;
            break;
        }
        if ((pickedMoveScope = this.forager.pickMove(stepScope)) != null) {
            Move step = pickedMoveScope.getMove();
            stepScope.setStep(step);
            if (this.logger.isDebugEnabled()) {
                stepScope.setStepString(step.toString());
            }
            stepScope.setUndoStep(pickedMoveScope.getUndoMove());
            stepScope.setScore(pickedMoveScope.getScore());
        }
    }

    private void doMove(MoveScope moveScope) {
        Score lastCompletedStepScore;
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope;
        Score undoScore;
        ScoreDirector scoreDirector = moveScope.getScoreDirector();
        Move move = moveScope.getMove();
        Move undoMove = move.createUndoMove(scoreDirector);
        moveScope.setUndoMove(undoMove);
        move.doMove(scoreDirector);
        this.processMove(moveScope);
        undoMove.doMove(scoreDirector);
        if (this.assertUndoMoveIsUncorrupted && !(undoScore = (localSearchSolverPhaseScope = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope()).calculateScore()).equals(lastCompletedStepScore = localSearchSolverPhaseScope.getLastCompletedStepScope().getScore())) {
            scoreDirector.assertWorkingScore(undoScore);
            throw new IllegalStateException("The moveClass (" + move.getClass() + ")'s move (" + move + ") probably has a corrupted undoMove (" + undoMove + ")." + " Or maybe there are corrupted score rules.\n" + "Check the Move.createUndoMove(...) method of that Move class" + " and enable EnvironmentMode TRACE to fail-faster on corrupted score rules.\n" + "Score corruption: the lastCompletedStepScore (" + lastCompletedStepScore + ") is not the undoScore (" + undoScore + ").");
        }
        this.logger.trace("        Move index ({}), score ({}), accepted ({}) for move ({}).", new Object[]{moveScope.getMoveIndex(), moveScope.getScore(), moveScope.getAccepted(), moveScope.getMove()});
    }

    private void processMove(MoveScope moveScope) {
        Score score = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().calculateScore();
        if (this.assertMoveScoreIsUncorrupted) {
            moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().assertWorkingScore(score);
        }
        moveScope.setScore(score);
        boolean accepted = this.acceptor.isAccepted(moveScope);
        moveScope.setAccepted(accepted);
        this.forager.addMove(moveScope);
    }

    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        this.moveSelector.stepEnded(localSearchStepScope);
        this.acceptor.stepEnded(localSearchStepScope);
        this.forager.stepEnded(localSearchStepScope);
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.moveSelector.phaseEnded(localSearchSolverPhaseScope);
        this.acceptor.phaseEnded(localSearchSolverPhaseScope);
        this.forager.phaseEnded(localSearchSolverPhaseScope);
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        this.moveSelector.solvingEnded(solverScope);
        this.acceptor.solvingEnded(solverScope);
        this.forager.solvingEnded(solverScope);
    }
}

