/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.lateacceptance;

import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class LateAcceptanceAcceptor
extends AbstractAcceptor {
    protected int lateAcceptanceSize = -1;
    protected Score[] previousScores;
    protected int lateScoreIndex = -1;

    public void setLateAcceptanceSize(int lateAcceptanceSize) {
        this.lateAcceptanceSize = lateAcceptanceSize;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.validate();
        this.previousScores = new Score[this.lateAcceptanceSize];
        Score initialScore = localSearchSolverPhaseScope.getBestScore();
        for (int i = 0; i < this.previousScores.length; ++i) {
            this.previousScores[i] = initialScore;
        }
        this.lateScoreIndex = 0;
    }

    private void validate() {
        if (this.lateAcceptanceSize <= 0) {
            throw new IllegalArgumentException("The lateAcceptanceSize (" + this.lateAcceptanceSize + ") cannot be negative or zero.");
        }
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.previousScores = null;
        this.lateScoreIndex = -1;
    }

    public boolean isAccepted(MoveScope moveScope) {
        moveScope.getLocalSearchStepScope().getStepIndex();
        Score score = moveScope.getScore();
        Score lateScore = this.previousScores[this.lateScoreIndex];
        return score.compareTo(lateScore) >= 0;
    }

    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        super.stepEnded(localSearchStepScope);
        this.previousScores[this.lateScoreIndex] = localSearchStepScope.getScore();
        this.lateScoreIndex = (this.lateScoreIndex + 1) % this.lateAcceptanceSize;
    }
}

