/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.simulatedannealing;

import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;
import org.drools.planner.core.score.Score;

public class SimulatedAnnealingAcceptor
extends AbstractAcceptor {
    protected Score startingTemperature;
    protected int levelsLength = -1;
    protected double[] startingTemperatureLevels;
    protected double[] temperatureLevels;
    protected double temperatureMinimum = 1.0E-100;

    public void setStartingTemperature(Score startingTemperature) {
        this.startingTemperature = startingTemperature;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        for (double startingTemperatureLevel : this.startingTemperature.toDoubleLevels()) {
            if (!(startingTemperatureLevel < 0.0)) continue;
            throw new IllegalArgumentException("The startingTemperature (" + this.startingTemperature + ") cannot have negative level (" + startingTemperatureLevel + ").");
        }
        this.startingTemperatureLevels = this.startingTemperature.toDoubleLevels();
        this.temperatureLevels = this.startingTemperatureLevels;
        this.levelsLength = this.startingTemperatureLevels.length;
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.startingTemperatureLevels = null;
        this.temperatureLevels = null;
        this.levelsLength = -1;
    }

    public boolean isAccepted(MoveScope moveScope) {
        LocalSearchSolverPhaseScope localSearchSolverPhaseScope = moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope();
        Score lastStepScore = localSearchSolverPhaseScope.getLastCompletedLocalSearchStepScope().getScore();
        Score moveScore = moveScope.getScore();
        if (moveScore.compareTo(lastStepScore) >= 0) {
            return true;
        }
        Score scoreDifference = lastStepScore.subtract(moveScore);
        double acceptChance = 1.0;
        double[] scoreDifferenceLevels = scoreDifference.toDoubleLevels();
        for (int i = 0; i < this.levelsLength; ++i) {
            double scoreDifferenceLevel = scoreDifferenceLevels[i];
            double temperatureLevel = this.temperatureLevels[i];
            double acceptChanceLevel = scoreDifferenceLevel <= 0.0 ? 1.0 : Math.exp(-scoreDifferenceLevel / temperatureLevel);
            acceptChance *= acceptChanceLevel;
        }
        return moveScope.getWorkingRandom().nextDouble() < acceptChance;
    }

    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        super.stepEnded(localSearchStepScope);
        double timeGradient = localSearchStepScope.getTimeGradient();
        double reverseTimeGradient = 1.0 - timeGradient;
        this.temperatureLevels = new double[this.levelsLength];
        for (int i = 0; i < this.levelsLength; ++i) {
            this.temperatureLevels[i] = this.startingTemperatureLevels[i] * reverseTimeGradient;
            if (!(this.temperatureLevels[i] < this.temperatureMinimum)) continue;
            this.temperatureLevels[i] = this.temperatureMinimum;
        }
    }
}

