/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.acceptor.tabu;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.acceptor.AbstractAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTabuAcceptor
extends AbstractAcceptor {
    protected int tabuSize = -1;
    protected int fadingTabuSize = 0;
    protected boolean aspirationEnabled = true;
    protected boolean assertTabuHashCodeCorrectness = false;
    protected Map<Object, Integer> tabuToStepIndexMap;
    protected List<Object> tabuSequenceList;

    public void setTabuSize(int tabuSize) {
        this.tabuSize = tabuSize;
    }

    public void setFadingTabuSize(int fadingTabuSize) {
        this.fadingTabuSize = fadingTabuSize;
    }

    public void setAspirationEnabled(boolean aspirationEnabled) {
        this.aspirationEnabled = aspirationEnabled;
    }

    public void setAssertTabuHashCodeCorrectness(boolean assertTabuHashCodeCorrectness) {
        this.assertTabuHashCodeCorrectness = assertTabuHashCodeCorrectness;
    }

    @Override
    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseStarted(localSearchSolverPhaseScope);
        this.validate();
        this.tabuToStepIndexMap = new HashMap<Object, Integer>(this.tabuSize + this.fadingTabuSize);
        this.tabuSequenceList = new LinkedList<Object>();
    }

    private void validate() {
        if (this.tabuSize < 0) {
            throw new IllegalArgumentException("The tabuSize (" + this.tabuSize + ") cannot be negative.");
        }
        if (this.fadingTabuSize < 0) {
            throw new IllegalArgumentException("The fadingTabuSize (" + this.fadingTabuSize + ") cannot be negative.");
        }
        if (this.tabuSize + this.fadingTabuSize == 0) {
            throw new IllegalArgumentException("The sum of tabuSize and fadingTabuSize should be at least 1.");
        }
    }

    @Override
    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        super.phaseEnded(localSearchSolverPhaseScope);
        this.tabuToStepIndexMap = null;
        this.tabuSequenceList = null;
    }

    @Override
    public boolean isAccepted(MoveScope moveScope) {
        boolean accepted;
        Collection<? extends Object> checkingTabus = this.findTabu(moveScope);
        int maximumTabuStepIndex = -1;
        for (Object object : checkingTabus) {
            Integer tabuStepIndexInteger = this.tabuToStepIndexMap.get(object);
            if (tabuStepIndexInteger != null) {
                maximumTabuStepIndex = Math.max(tabuStepIndexInteger, maximumTabuStepIndex);
            }
            if (!this.assertTabuHashCodeCorrectness) continue;
            for (Object tabu : this.tabuSequenceList) {
                if (!tabu.equals(object)) continue;
                if (tabu.hashCode() != object.hashCode()) {
                    throw new IllegalStateException("HashCode violation: tabu (" + tabu + ") and checkingTabu (" + object + ") are equal but have a different hashCode.");
                }
                if (tabuStepIndexInteger != null) continue;
                throw new IllegalStateException("HashCode violation: the hashCode of tabu (" + tabu + ") probably changed since it was inserted in the tabu Map or Set.");
            }
        }
        if (maximumTabuStepIndex < 0) {
            return true;
        }
        if (this.aspirationEnabled && moveScope.getScore().compareTo(moveScope.getLocalSearchStepScope().getLocalSearchSolverPhaseScope().getBestScore()) > 0) {
            this.logger.trace("        Proposed move ({}) is tabu, but is accepted anyway due to aspiration.", (Object)moveScope.getMove());
            return true;
        }
        int tabuStepCount = moveScope.getLocalSearchStepScope().getStepIndex() - maximumTabuStepIndex;
        if (tabuStepCount <= this.tabuSize) {
            this.logger.trace("        Proposed move ({}) is tabu and is therefore not accepted.", (Object)moveScope.getMove());
            return false;
        }
        double d = this.calculateFadingTabuAcceptChance(tabuStepCount - this.tabuSize);
        boolean bl = accepted = moveScope.getWorkingRandom().nextDouble() < d;
        if (accepted) {
            this.logger.trace("        Proposed move ({}) is fading tabu with acceptChance ({}) and is accepted.", (Object)moveScope.getMove(), (Object)d);
        } else {
            this.logger.trace("        Proposed move ({}) is fading tabu with acceptChance ({}) and is not accepted.", (Object)moveScope.getMove(), (Object)d);
        }
        return accepted;
    }

    protected double calculateFadingTabuAcceptChance(int fadingTabuStepCount) {
        return (double)(this.fadingTabuSize - fadingTabuStepCount) / (double)(this.fadingTabuSize + 1);
    }

    @Override
    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        int maximumTabuListSize = this.tabuSize + this.fadingTabuSize;
        int tabuStepIndex = localSearchStepScope.getStepIndex();
        Iterator<Object> it = this.tabuSequenceList.iterator();
        while (it.hasNext()) {
            Object oldTabu = it.next();
            Integer n = this.tabuToStepIndexMap.get(oldTabu);
            if (n == null) {
                throw new IllegalStateException("HashCode violation: the hashCode of tabu (" + oldTabu + ") probably changed since it was inserted in the tabu Map or Set.");
            }
            int oldTabuStepCount = tabuStepIndex - n;
            if (oldTabuStepCount < maximumTabuListSize) break;
            it.remove();
            this.tabuToStepIndexMap.remove(oldTabu);
        }
        Collection<? extends Object> tabus = this.findNewTabu(localSearchStepScope);
        for (Object object : tabus) {
            if (this.tabuToStepIndexMap.containsKey(object)) {
                this.tabuToStepIndexMap.remove(object);
                this.tabuSequenceList.remove(object);
            }
            this.tabuToStepIndexMap.put(object, tabuStepIndex);
            this.tabuSequenceList.add(object);
        }
    }

    protected abstract Collection<? extends Object> findTabu(MoveScope var1);

    protected abstract Collection<? extends Object> findNewTabu(LocalSearchStepScope var1);
}

