/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.localsearch.decider.forager;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.drools.planner.core.localsearch.LocalSearchSolverPhaseScope;
import org.drools.planner.core.localsearch.LocalSearchStepScope;
import org.drools.planner.core.localsearch.decider.MoveScope;
import org.drools.planner.core.localsearch.decider.deciderscorecomparator.DeciderScoreComparatorFactory;
import org.drools.planner.core.localsearch.decider.forager.AbstractForager;
import org.drools.planner.core.localsearch.decider.forager.PickEarlyType;
import org.drools.planner.core.score.Score;

public class AcceptedForager
extends AbstractForager {
    protected DeciderScoreComparatorFactory deciderScoreComparatorFactory;
    protected final PickEarlyType pickEarlyType;
    protected final int minimalAcceptedSelection;
    protected Comparator<Score> scoreComparator;
    protected long selectedMoveCount;
    protected long acceptedMoveCount;
    protected List<MoveScope> maxScoreAcceptedList;
    protected Score maxAcceptedScore;
    protected List<MoveScope> maxScoreUnacceptedList;
    protected Score maxUnacceptedScore;
    protected MoveScope earlyPickedMoveScope;

    public AcceptedForager(PickEarlyType pickEarlyType, int minimalAcceptedSelection) {
        this.pickEarlyType = pickEarlyType;
        this.minimalAcceptedSelection = minimalAcceptedSelection;
        if (minimalAcceptedSelection < 1) {
            throw new IllegalArgumentException("The minimalAcceptedSelection (" + minimalAcceptedSelection + ") cannot be negative or zero.");
        }
    }

    public void setDeciderScoreComparatorFactory(DeciderScoreComparatorFactory deciderScoreComparator) {
        this.deciderScoreComparatorFactory = deciderScoreComparator;
    }

    public void phaseStarted(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseStarted(localSearchSolverPhaseScope);
    }

    public void stepStarted(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepStarted(localSearchStepScope);
        this.scoreComparator = this.deciderScoreComparatorFactory.createDeciderScoreComparator();
        this.selectedMoveCount = 0L;
        this.acceptedMoveCount = 0L;
        this.maxScoreAcceptedList = new ArrayList<MoveScope>(1024);
        this.maxAcceptedScore = localSearchStepScope.getSolverPhaseScope().getScoreDefinition().getPerfectMinimumScore();
        this.maxScoreUnacceptedList = new ArrayList<MoveScope>(1024);
        this.maxUnacceptedScore = localSearchStepScope.getSolverPhaseScope().getScoreDefinition().getPerfectMinimumScore();
        this.earlyPickedMoveScope = null;
    }

    public boolean supportsNeverEndingMoveSelector() {
        return this.minimalAcceptedSelection < Integer.MAX_VALUE;
    }

    public void addMove(MoveScope moveScope) {
        ++this.selectedMoveCount;
        if (moveScope.getAccepted().booleanValue()) {
            ++this.acceptedMoveCount;
            this.checkPickEarly(moveScope);
            this.addToMaxScoreAcceptedList(moveScope);
            this.maxScoreUnacceptedList = null;
        } else if (this.acceptedMoveCount == 0L) {
            this.addToMaxScoreUnacceptedList(moveScope);
        }
    }

    protected void checkPickEarly(MoveScope moveScope) {
        switch (this.pickEarlyType) {
            case NEVER: {
                break;
            }
            case FIRST_BEST_SCORE_IMPROVING: {
                Score bestScore = moveScope.getLocalSearchStepScope().getSolverPhaseScope().getBestScore();
                if (this.scoreComparator.compare(moveScope.getScore(), bestScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            case FIRST_LAST_STEP_SCORE_IMPROVING: {
                Score lastStepScore = moveScope.getLocalSearchStepScope().getSolverPhaseScope().getLastCompletedStepScope().getScore();
                if (this.scoreComparator.compare(moveScope.getScore(), lastStepScore) <= 0) break;
                this.earlyPickedMoveScope = moveScope;
                break;
            }
            default: {
                throw new IllegalStateException("The pickEarlyType (" + (Object)((Object)this.pickEarlyType) + ") is not implemented");
            }
        }
    }

    protected void addToMaxScoreAcceptedList(MoveScope moveScope) {
        if (this.scoreComparator.compare(moveScope.getScore(), this.maxAcceptedScore) > 0) {
            this.maxAcceptedScore = moveScope.getScore();
            this.maxScoreAcceptedList.clear();
            this.maxScoreAcceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxAcceptedScore)) {
            this.maxScoreAcceptedList.add(moveScope);
        }
    }

    protected void addToMaxScoreUnacceptedList(MoveScope moveScope) {
        if (this.scoreComparator.compare(moveScope.getScore(), this.maxUnacceptedScore) > 0) {
            this.maxUnacceptedScore = moveScope.getScore();
            this.maxScoreUnacceptedList.clear();
            this.maxScoreUnacceptedList.add(moveScope);
        } else if (moveScope.getScore().equals(this.maxUnacceptedScore)) {
            this.maxScoreUnacceptedList.add(moveScope);
        }
    }

    public boolean isQuitEarly() {
        return this.earlyPickedMoveScope != null || this.acceptedMoveCount >= (long)this.minimalAcceptedSelection;
    }

    public MoveScope pickMove(LocalSearchStepScope localSearchStepScope) {
        localSearchStepScope.setSelectedMoveCount(this.selectedMoveCount);
        localSearchStepScope.setAcceptedMoveCount(this.acceptedMoveCount);
        if (this.earlyPickedMoveScope != null) {
            return this.earlyPickedMoveScope;
        }
        return this.pickMaxScoreMoveScope(localSearchStepScope);
    }

    protected MoveScope pickMaxScoreMoveScope(LocalSearchStepScope localSearchStepScope) {
        List<MoveScope> maxScoreList;
        if (this.maxScoreAcceptedList.isEmpty()) {
            if (this.maxScoreUnacceptedList.isEmpty()) {
                return null;
            }
            maxScoreList = this.maxScoreUnacceptedList;
        } else {
            maxScoreList = this.maxScoreAcceptedList;
        }
        if (maxScoreList.size() == 1) {
            return maxScoreList.get(0);
        }
        int randomIndex = localSearchStepScope.getWorkingRandom().nextInt(maxScoreList.size());
        return maxScoreList.get(randomIndex);
    }

    public void stepEnded(LocalSearchStepScope localSearchStepScope) {
        this.deciderScoreComparatorFactory.stepEnded(localSearchStepScope);
    }

    public void phaseEnded(LocalSearchSolverPhaseScope localSearchSolverPhaseScope) {
        this.deciderScoreComparatorFactory.phaseEnded(localSearchSolverPhaseScope);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + (Object)((Object)this.pickEarlyType) + ", " + this.minimalAcceptedSelection + ")";
    }
}

