/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.phase;

import org.drools.planner.core.bestsolution.BestSolutionRecaller;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.SolverPhase;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleListener;
import org.drools.planner.core.phase.event.SolverPhaseLifecycleSupport;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.Termination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSolverPhase
implements SolverPhase {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Termination termination;
    protected BestSolutionRecaller bestSolutionRecaller;
    protected SolverPhaseLifecycleSupport solverPhaseLifecycleSupport = new SolverPhaseLifecycleSupport();

    public Termination getTermination() {
        return this.termination;
    }

    public void setTermination(Termination termination) {
        this.termination = termination;
    }

    public void setBestSolutionRecaller(BestSolutionRecaller bestSolutionRecaller) {
        this.bestSolutionRecaller = bestSolutionRecaller;
    }

    public void solvingStarted(DefaultSolverScope solverScope) {
        this.termination.solvingStarted(solverScope);
        this.solverPhaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    public void solvingEnded(DefaultSolverScope solverScope) {
        this.termination.solvingEnded(solverScope);
        this.solverPhaseLifecycleSupport.fireSolvingStarted(solverScope);
    }

    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        solverPhaseScope.reset();
        this.bestSolutionRecaller.phaseStarted(solverPhaseScope);
        this.termination.phaseStarted(solverPhaseScope);
        this.solverPhaseLifecycleSupport.firePhaseStarted(solverPhaseScope);
    }

    public void stepStarted(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepStarted(stepScope);
        this.termination.stepStarted(stepScope);
        this.solverPhaseLifecycleSupport.fireStepStarted(stepScope);
    }

    public void stepEnded(AbstractStepScope stepScope) {
        this.bestSolutionRecaller.stepEnded(stepScope);
        this.termination.stepEnded(stepScope);
        this.solverPhaseLifecycleSupport.fireStepEnded(stepScope);
    }

    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        this.bestSolutionRecaller.phaseEnded(solverPhaseScope);
        this.termination.phaseEnded(solverPhaseScope);
        this.solverPhaseLifecycleSupport.firePhaseEnded(solverPhaseScope);
    }

    public void addSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.addEventListener(lifecycleListener);
    }

    public void removeSolverPhaseLifecycleListener(SolverPhaseLifecycleListener lifecycleListener) {
        this.solverPhaseLifecycleSupport.removeEventListener(lifecycleListener);
    }
}

