/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.core.termination;

import java.util.Arrays;
import java.util.List;
import org.drools.planner.core.phase.AbstractSolverPhaseScope;
import org.drools.planner.core.phase.step.AbstractStepScope;
import org.drools.planner.core.solver.DefaultSolverScope;
import org.drools.planner.core.termination.AbstractTermination;
import org.drools.planner.core.termination.Termination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompositeTermination
extends AbstractTermination
implements Termination {
    protected List<Termination> terminationList;

    public AbstractCompositeTermination() {
    }

    public AbstractCompositeTermination(Termination ... terminations) {
        this.terminationList = Arrays.asList(terminations);
    }

    public void setTerminationList(List<Termination> terminationList) {
        this.terminationList = terminationList;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingStarted(solverScope);
        }
    }

    @Override
    public void phaseStarted(AbstractSolverPhaseScope solverPhaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseStarted(solverPhaseScope);
        }
    }

    @Override
    public void stepStarted(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepStarted(stepScope);
        }
    }

    @Override
    public void stepEnded(AbstractStepScope stepScope) {
        for (Termination termination : this.terminationList) {
            termination.stepEnded(stepScope);
        }
    }

    @Override
    public void phaseEnded(AbstractSolverPhaseScope solverPhaseScope) {
        for (Termination termination : this.terminationList) {
            termination.phaseEnded(solverPhaseScope);
        }
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        for (Termination termination : this.terminationList) {
            termination.solvingEnded(solverScope);
        }
    }
}

