/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.drools.planner.benchmark.api.PlannerBenchmark;
import org.drools.planner.benchmark.api.ranking.SolverBenchmarkRankingWeightFactory;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.statistic.BenchmarkReport;
import org.drools.planner.config.SolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPlannerBenchmark
implements PlannerBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private File benchmarkDirectory = null;
    private File benchmarkReportDirectory = null;
    private Comparator<SolverBenchmark> solverBenchmarkRankingComparator = null;
    private SolverBenchmarkRankingWeightFactory solverBenchmarkRankingWeightFactory = null;
    private int parallelBenchmarkCount = -1;
    private long warmUpTimeMillisSpend = 0L;
    private List<SolverBenchmark> solverBenchmarkList = null;
    private List<ProblemBenchmark> unifiedProblemBenchmarkList = null;
    private final BenchmarkReport benchmarkReport = new BenchmarkReport(this);
    private long startingSystemTimeMillis;
    private Date startingTimestamp;
    private String plannerVersion;
    private ExecutorService executorService;
    private Integer failureCount;
    private SingleBenchmark firstFailureSingleBenchmark;
    private Long averageProblemScale = null;
    private SolverBenchmark favoriteSolverBenchmark;
    private long benchmarkTimeMillisSpend;

    public File getBenchmarkDirectory() {
        return this.benchmarkDirectory;
    }

    public void setBenchmarkDirectory(File benchmarkDirectory) {
        this.benchmarkDirectory = benchmarkDirectory;
    }

    public File getBenchmarkReportDirectory() {
        return this.benchmarkReportDirectory;
    }

    public Comparator<SolverBenchmark> getSolverBenchmarkRankingComparator() {
        return this.solverBenchmarkRankingComparator;
    }

    public void setSolverBenchmarkRankingComparator(Comparator<SolverBenchmark> solverBenchmarkRankingComparator) {
        this.solverBenchmarkRankingComparator = solverBenchmarkRankingComparator;
    }

    public SolverBenchmarkRankingWeightFactory getSolverBenchmarkRankingWeightFactory() {
        return this.solverBenchmarkRankingWeightFactory;
    }

    public void setSolverBenchmarkRankingWeightFactory(SolverBenchmarkRankingWeightFactory solverBenchmarkRankingWeightFactory) {
        this.solverBenchmarkRankingWeightFactory = solverBenchmarkRankingWeightFactory;
    }

    public int getParallelBenchmarkCount() {
        return this.parallelBenchmarkCount;
    }

    public void setParallelBenchmarkCount(int parallelBenchmarkCount) {
        this.parallelBenchmarkCount = parallelBenchmarkCount;
    }

    public long getWarmUpTimeMillisSpend() {
        return this.warmUpTimeMillisSpend;
    }

    public void setWarmUpTimeMillisSpend(long warmUpTimeMillisSpend) {
        this.warmUpTimeMillisSpend = warmUpTimeMillisSpend;
    }

    public List<SolverBenchmark> getSolverBenchmarkList() {
        return this.solverBenchmarkList;
    }

    public void setSolverBenchmarkList(List<SolverBenchmark> solverBenchmarkList) {
        this.solverBenchmarkList = solverBenchmarkList;
    }

    public List<ProblemBenchmark> getUnifiedProblemBenchmarkList() {
        return this.unifiedProblemBenchmarkList;
    }

    public void setUnifiedProblemBenchmarkList(List<ProblemBenchmark> unifiedProblemBenchmarkList) {
        this.unifiedProblemBenchmarkList = unifiedProblemBenchmarkList;
    }

    public Date getStartingTimestamp() {
        return this.startingTimestamp;
    }

    public String getPlannerVersion() {
        return this.plannerVersion;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public Long getAverageProblemScale() {
        return this.averageProblemScale;
    }

    public long getBenchmarkTimeMillisSpend() {
        return this.benchmarkTimeMillisSpend;
    }

    public BenchmarkReport getBenchmarkReport() {
        return this.benchmarkReport;
    }

    public boolean hasMultipleParallelBenchmarks() {
        return this.parallelBenchmarkCount > 1;
    }

    @Override
    public void benchmark() {
        this.benchmarkingStarted();
        this.warmUp();
        this.runSingleBenchmarks();
        this.benchmarkingEnded();
    }

    public void benchmarkingStarted() {
        this.startingSystemTimeMillis = System.currentTimeMillis();
        this.startingTimestamp = new Date();
        if (this.solverBenchmarkList == null || this.solverBenchmarkList.isEmpty()) {
            throw new IllegalArgumentException("The solverBenchmarkList (" + this.solverBenchmarkList + ") cannot be empty.");
        }
        this.plannerVersion = SolverFactory.class.getPackage().getImplementationVersion();
        this.initBenchmarkDirectoryAndSubdirs();
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.benchmarkingStarted();
        }
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            problemBenchmark.benchmarkingStarted();
        }
        this.executorService = Executors.newFixedThreadPool(this.parallelBenchmarkCount);
        this.failureCount = 0;
        this.firstFailureSingleBenchmark = null;
        this.averageProblemScale = null;
        this.favoriteSolverBenchmark = null;
        this.benchmarkTimeMillisSpend = -1L;
        this.logger.info("Benchmarking started: solverBenchmarkList size ({}), parallelBenchmarkCount ({}).", (Object)this.solverBenchmarkList.size(), (Object)this.parallelBenchmarkCount);
    }

    private void initBenchmarkDirectoryAndSubdirs() {
        if (this.benchmarkDirectory == null) {
            throw new IllegalArgumentException("The benchmarkDirectory (" + this.benchmarkDirectory + ") must not be null.");
        }
        this.benchmarkDirectory.mkdirs();
        String timestamp = new SimpleDateFormat("yyyy-MM-dd_HHmmss").format(this.startingTimestamp);
        this.benchmarkReportDirectory = new File(this.benchmarkDirectory, timestamp);
        this.benchmarkReportDirectory.mkdirs();
    }

    private void warmUp() {
        if (this.warmUpTimeMillisSpend > 0L) {
            this.logger.info("================================================================================");
            this.logger.info("Warming up");
            this.logger.info("================================================================================");
            long startingTimeMillis = System.currentTimeMillis();
            long timeLeft = this.warmUpTimeMillisSpend;
            Iterator<ProblemBenchmark> it = this.unifiedProblemBenchmarkList.iterator();
            while (timeLeft > 0L) {
                if (!it.hasNext()) {
                    it = this.unifiedProblemBenchmarkList.iterator();
                }
                ProblemBenchmark problemBenchmark = it.next();
                timeLeft = problemBenchmark.warmUp(startingTimeMillis, this.warmUpTimeMillisSpend, timeLeft);
            }
            this.logger.info("================================================================================");
            this.logger.info("Finished warmUp");
            this.logger.info("================================================================================");
        }
    }

    protected void runSingleBenchmarks() {
        HashMap<SingleBenchmark, Future<SingleBenchmark>> futureMap = new HashMap<SingleBenchmark, Future<SingleBenchmark>>();
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            for (SingleBenchmark singleBenchmark : problemBenchmark.getSingleBenchmarkList()) {
                Future<SingleBenchmark> future = this.executorService.submit(singleBenchmark);
                futureMap.put(singleBenchmark, future);
            }
        }
        for (Map.Entry entry : futureMap.entrySet()) {
            SingleBenchmark singleBenchmark = (SingleBenchmark)entry.getKey();
            Future future = (Future)entry.getValue();
            Throwable failureThrowable = null;
            try {
                singleBenchmark = (SingleBenchmark)future.get();
                if (singleBenchmark.getScore() == null) {
                    throw new IllegalStateException("Score is null. TODO fix JBRULES-3462.");
                }
            }
            catch (InterruptedException e) {
                this.logger.error("The singleBenchmark (" + singleBenchmark.getName() + ") was interrupted.", (Throwable)e);
                failureThrowable = e;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                this.logger.error("The singleBenchmark (" + singleBenchmark.getName() + ") failed.", cause);
                failureThrowable = cause;
            }
            catch (IllegalStateException e) {
                this.logger.error("The singleBenchmark (" + singleBenchmark.getName() + ") failed.", (Throwable)e);
                failureThrowable = e;
            }
            if (failureThrowable == null) {
                singleBenchmark.setSucceeded(true);
                continue;
            }
            singleBenchmark.setSucceeded(false);
            singleBenchmark.setFailureThrowable(failureThrowable);
            Integer n = this.failureCount;
            Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
            if (this.firstFailureSingleBenchmark != null) continue;
            this.firstFailureSingleBenchmark = singleBenchmark;
        }
    }

    public long calculateTimeMillisSpend() {
        long now = System.currentTimeMillis();
        return now - this.startingSystemTimeMillis;
    }

    public void benchmarkingEnded() {
        this.executorService.shutdownNow();
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            problemBenchmark.benchmarkingEnded();
        }
        for (SolverBenchmark solverBenchmark : this.solverBenchmarkList) {
            solverBenchmark.benchmarkingEnded();
        }
        this.determineTotalsAndAverages();
        this.determineSolverBenchmarkRanking();
        this.benchmarkTimeMillisSpend = this.calculateTimeMillisSpend();
        this.benchmarkReport.writeReport();
        if (this.failureCount != 0) {
            this.logger.info("Benchmarking failed: time spend ({}), failureCount ({}), statistic html overview ({}).", new Object[]{this.benchmarkTimeMillisSpend, this.failureCount, this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
            throw new IllegalStateException("Benchmarking failed: failureCount (" + this.failureCount + ")." + " The exception of the firstFailureSingleBenchmark (" + this.firstFailureSingleBenchmark.getName() + ") is chained.", this.firstFailureSingleBenchmark.getFailureThrowable());
        }
        this.logger.info("Benchmarking ended: time spend ({}), favoriteSolverBenchmark ({}), statistic html overview ({}).", new Object[]{this.benchmarkTimeMillisSpend, this.favoriteSolverBenchmark.getName(), this.benchmarkReport.getHtmlOverviewFile().getAbsolutePath()});
    }

    private void determineTotalsAndAverages() {
        long totalProblemScale = 0L;
        int problemScaleCount = 0;
        for (ProblemBenchmark problemBenchmark : this.unifiedProblemBenchmarkList) {
            Long problemScale = problemBenchmark.getProblemScale();
            if (problemScale == null || problemScale < 0L) continue;
            totalProblemScale += problemScale.longValue();
            ++problemScaleCount;
        }
        this.averageProblemScale = problemScaleCount == 0 ? null : Long.valueOf(totalProblemScale / (long)problemScaleCount);
    }

    private void determineSolverBenchmarkRanking() {
        ArrayList<SolverBenchmark> rankedSolverBenchmarkList = new ArrayList<SolverBenchmark>(this.solverBenchmarkList);
        Iterator it = rankedSolverBenchmarkList.iterator();
        while (it.hasNext()) {
            SolverBenchmark solverBenchmark = (SolverBenchmark)it.next();
            if (!solverBenchmark.hasAnyFailure()) continue;
            it.remove();
        }
        if (this.solverBenchmarkRankingComparator != null) {
            Collections.sort(rankedSolverBenchmarkList, Collections.reverseOrder(this.solverBenchmarkRankingComparator));
        } else if (this.solverBenchmarkRankingWeightFactory != null) {
            TreeMap<Comparable, SolverBenchmark> rankedSolverBenchmarkMap = new TreeMap<Comparable, SolverBenchmark>((Comparator<Comparable>)new ReverseComparator());
            for (SolverBenchmark solverBenchmark : rankedSolverBenchmarkList) {
                Comparable rankingWeight = this.solverBenchmarkRankingWeightFactory.createRankingWeight(rankedSolverBenchmarkList, solverBenchmark);
                SolverBenchmark previous = rankedSolverBenchmarkMap.put(rankingWeight, solverBenchmark);
                if (previous == null) continue;
                throw new IllegalStateException("The solverBenchmarkList contains 2 times the same solverBenchmark (" + previous + ") and (" + solverBenchmark + ").");
            }
            rankedSolverBenchmarkList.clear();
            rankedSolverBenchmarkList.addAll(rankedSolverBenchmarkMap.values());
        } else {
            throw new IllegalStateException("Ranking is impossible because solverBenchmarkRankingComparator and solverBenchmarkRankingWeightFactory are null.");
        }
        int ranking = 0;
        for (SolverBenchmark solverBenchmark : rankedSolverBenchmarkList) {
            solverBenchmark.setRanking(ranking);
            ++ranking;
        }
        this.favoriteSolverBenchmark = rankedSolverBenchmarkList.isEmpty() ? null : (SolverBenchmark)rankedSolverBenchmarkList.get(0);
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }
}

