/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.planner.benchmark.core.DefaultPlannerBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.measurement.ScoreDifferencePercentage;
import org.drools.planner.benchmark.core.ranking.SingleBenchmarkRankingComparator;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.config.termination.TerminationConfig;
import org.drools.planner.core.Solver;
import org.drools.planner.core.solution.ProblemIO;
import org.drools.planner.core.solution.Solution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemBenchmark {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DefaultPlannerBenchmark plannerBenchmark;
    private String name = null;
    private ProblemIO problemIO = null;
    private boolean writeOutputSolutionEnabled = true;
    private File inputSolutionFile = null;
    private File problemReportDirectory = null;
    private List<ProblemStatistic> problemStatisticList = null;
    private List<SingleBenchmark> singleBenchmarkList = null;
    private Long problemScale = null;
    private Long averageUsedMemoryAfterInputSolution = null;
    private Integer failureCount = null;
    private SingleBenchmark winningSingleBenchmark = null;
    private SingleBenchmark worstSingleBenchmark = null;

    public ProblemBenchmark(DefaultPlannerBenchmark plannerBenchmark) {
        this.plannerBenchmark = plannerBenchmark;
    }

    public DefaultPlannerBenchmark getPlannerBenchmark() {
        return this.plannerBenchmark;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProblemIO getProblemIO() {
        return this.problemIO;
    }

    public void setProblemIO(ProblemIO problemIO) {
        this.problemIO = problemIO;
    }

    public boolean isWriteOutputSolutionEnabled() {
        return this.writeOutputSolutionEnabled;
    }

    public void setWriteOutputSolutionEnabled(boolean writeOutputSolutionEnabled) {
        this.writeOutputSolutionEnabled = writeOutputSolutionEnabled;
    }

    public File getInputSolutionFile() {
        return this.inputSolutionFile;
    }

    public File getProblemReportDirectory() {
        return this.problemReportDirectory;
    }

    public void setInputSolutionFile(File inputSolutionFile) {
        this.inputSolutionFile = inputSolutionFile;
    }

    public List<ProblemStatistic> getProblemStatisticList() {
        return this.problemStatisticList;
    }

    public void setProblemStatisticList(List<ProblemStatistic> problemStatisticList) {
        this.problemStatisticList = problemStatisticList;
    }

    public List<SingleBenchmark> getSingleBenchmarkList() {
        return this.singleBenchmarkList;
    }

    public void setSingleBenchmarkList(List<SingleBenchmark> singleBenchmarkList) {
        this.singleBenchmarkList = singleBenchmarkList;
    }

    public Long getProblemScale() {
        return this.problemScale;
    }

    public Long getAverageUsedMemoryAfterInputSolution() {
        return this.averageUsedMemoryAfterInputSolution;
    }

    public Integer getFailureCount() {
        return this.failureCount;
    }

    public SingleBenchmark getWinningSingleBenchmark() {
        return this.winningSingleBenchmark;
    }

    public SingleBenchmark getWorstSingleBenchmark() {
        return this.worstSingleBenchmark;
    }

    public void benchmarkingStarted() {
        this.problemReportDirectory = new File(this.plannerBenchmark.getBenchmarkReportDirectory(), this.name);
        this.problemReportDirectory.mkdirs();
        this.problemScale = null;
    }

    public long warmUp(long startingTimeMillis, long warmUpTimeMillisSpend, long timeLeft) {
        for (SingleBenchmark singleBenchmark : this.singleBenchmarkList) {
            SolverBenchmark solverBenchmark = singleBenchmark.getSolverBenchmark();
            TerminationConfig originalTerminationConfig = solverBenchmark.getSolverConfig().getTerminationConfig();
            TerminationConfig tmpTerminationConfig = originalTerminationConfig.clone();
            tmpTerminationConfig.shortenMaximumTimeMillisSpendTotal(timeLeft);
            solverBenchmark.getSolverConfig().setTerminationConfig(tmpTerminationConfig);
            Solver solver = solverBenchmark.getSolverConfig().buildSolver();
            solver.setPlanningProblem(this.readPlanningProblem());
            solver.solve();
            solverBenchmark.getSolverConfig().setTerminationConfig(originalTerminationConfig);
            long timeSpend = System.currentTimeMillis() - startingTimeMillis;
            timeLeft = warmUpTimeMillisSpend - timeSpend;
            if (timeLeft > 0L) continue;
            return timeLeft;
        }
        return timeLeft;
    }

    public Solution readPlanningProblem() {
        return this.problemIO.read(this.inputSolutionFile);
    }

    public void writeOutputSolution(SingleBenchmark singleBenchmark, Solution outputSolution) {
        if (!this.writeOutputSolutionEnabled) {
            return;
        }
        String filename = singleBenchmark.getName() + "." + this.problemIO.getFileExtension();
        File outputSolutionFile = new File(this.problemReportDirectory, filename);
        this.problemIO.write(outputSolution, outputSolutionFile);
    }

    public void benchmarkingEnded() {
        this.determineTotalsAndAveragesAndRanking();
        this.determineWinningScoreDifference();
    }

    private void determineTotalsAndAveragesAndRanking() {
        this.failureCount = 0;
        long totalUsedMemoryAfterInputSolution = 0L;
        int usedMemoryAfterInputSolutionCount = 0;
        ArrayList<SingleBenchmark> successSingleBenchmarkList = new ArrayList<SingleBenchmark>(this.singleBenchmarkList);
        Iterator it = successSingleBenchmarkList.iterator();
        while (it.hasNext()) {
            SingleBenchmark singleBenchmark = (SingleBenchmark)it.next();
            if (singleBenchmark.isFailure()) {
                Integer n = this.failureCount;
                Integer n2 = this.failureCount = Integer.valueOf(this.failureCount + 1);
                it.remove();
                continue;
            }
            if (singleBenchmark.getUsedMemoryAfterInputSolution() == null) continue;
            totalUsedMemoryAfterInputSolution += singleBenchmark.getUsedMemoryAfterInputSolution().longValue();
            ++usedMemoryAfterInputSolutionCount;
        }
        if (usedMemoryAfterInputSolutionCount > 0) {
            this.averageUsedMemoryAfterInputSolution = totalUsedMemoryAfterInputSolution / (long)usedMemoryAfterInputSolutionCount;
        }
        this.determineRanking(successSingleBenchmarkList);
    }

    private void determineRanking(List<SingleBenchmark> rankedSingleBenchmarkList) {
        Collections.sort(rankedSingleBenchmarkList, Collections.reverseOrder(new SingleBenchmarkRankingComparator()));
        int singleBenchmarkRanking = 0;
        for (SingleBenchmark singleBenchmark : rankedSingleBenchmarkList) {
            singleBenchmark.setRanking(singleBenchmarkRanking);
            ++singleBenchmarkRanking;
        }
        this.winningSingleBenchmark = rankedSingleBenchmarkList.isEmpty() ? null : rankedSingleBenchmarkList.get(0);
        this.worstSingleBenchmark = rankedSingleBenchmarkList.isEmpty() ? null : rankedSingleBenchmarkList.get(rankedSingleBenchmarkList.size() - 1);
    }

    private void determineWinningScoreDifference() {
        for (SingleBenchmark singleBenchmark : this.singleBenchmarkList) {
            if (singleBenchmark.isFailure()) continue;
            singleBenchmark.setWinningScoreDifference(singleBenchmark.getScore().subtract(this.winningSingleBenchmark.getScore()));
            singleBenchmark.setWorstScoreDifferencePercentage(ScoreDifferencePercentage.calculateScoreDifferencePercentage(this.worstSingleBenchmark.getScore(), singleBenchmark.getScore()));
        }
    }

    public boolean hasAnyFailure() {
        return this.failureCount > 0;
    }

    public boolean hasAnySuccess() {
        return this.singleBenchmarkList.size() - this.failureCount > 0;
    }

    public boolean hasAnyProblemStatistic() {
        return this.problemStatisticList.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProblemBenchmark) {
            ProblemBenchmark other = (ProblemBenchmark)o;
            return this.inputSolutionFile.equals(other.getInputSolutionFile());
        }
        return false;
    }

    public int hashCode() {
        return this.inputSolutionFile.hashCode();
    }

    public void registerProblemScale(long registeringProblemScale) {
        if (this.problemScale == null) {
            this.problemScale = registeringProblemScale;
        } else if (this.problemScale != registeringProblemScale) {
            this.logger.warn("The problemBenchmark ({}) has different problemScale values ([{},{}]).", new Object[]{this.getName(), this.problemScale, registeringProblemScale});
            this.problemScale = -1L;
        }
    }
}

