/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.ranking;

import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.drools.planner.benchmark.api.ranking.SolverBenchmarkRankingWeightFactory;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.ranking.TotalScoreSolverBenchmarkRankingComparator;
import org.drools.planner.core.score.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TotalRankSolverBenchmarkRankingWeightFactory
implements SolverBenchmarkRankingWeightFactory {
    @Override
    public Comparable createRankingWeight(List<SolverBenchmark> solverBenchmarkList, SolverBenchmark solverBenchmark) {
        int betterCount = 0;
        int equalCount = 0;
        List<Score> scoreList = solverBenchmark.getScoreList();
        for (SolverBenchmark otherSolverBenchmark : solverBenchmarkList) {
            if (otherSolverBenchmark == solverBenchmark) continue;
            List<Score> otherScoreList = otherSolverBenchmark.getScoreList();
            for (int i = 0; i < scoreList.size(); ++i) {
                Score otherScore;
                Score score = scoreList.get(i);
                int scoreComparison = score.compareTo((Object)(otherScore = otherScoreList.get(i)));
                if (scoreComparison > 0) {
                    ++betterCount;
                    continue;
                }
                if (scoreComparison != 0) continue;
                ++equalCount;
            }
        }
        return new TotalRankSolverBenchmarkRankingWeight(solverBenchmark, betterCount, equalCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TotalRankSolverBenchmarkRankingWeight
    implements Comparable<TotalRankSolverBenchmarkRankingWeight> {
        private final Comparator<SolverBenchmark> totalScoreSolverBenchmarkRankingComparator = new TotalScoreSolverBenchmarkRankingComparator();
        private SolverBenchmark solverBenchmark;
        private int betterCount;
        private int equalCount;

        public TotalRankSolverBenchmarkRankingWeight(SolverBenchmark solverBenchmark, int betterCount, int equalCount) {
            this.solverBenchmark = solverBenchmark;
            this.betterCount = betterCount;
            this.equalCount = equalCount;
        }

        @Override
        public int compareTo(TotalRankSolverBenchmarkRankingWeight other) {
            return new CompareToBuilder().append(this.betterCount, other.betterCount).append(this.equalCount, other.equalCount).append((Object)this.solverBenchmark, (Object)other.solverBenchmark, this.totalScoreSolverBenchmarkRankingComparator).toComparison();
        }
    }
}

