/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.benchmark.core.statistic;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.drools.planner.benchmark.core.DefaultPlannerBenchmark;
import org.drools.planner.benchmark.core.ProblemBenchmark;
import org.drools.planner.benchmark.core.SingleBenchmark;
import org.drools.planner.benchmark.core.SolverBenchmark;
import org.drools.planner.benchmark.core.statistic.MillisecondsSpendNumberFormat;
import org.drools.planner.benchmark.core.statistic.ProblemStatistic;
import org.drools.planner.benchmark.core.statistic.WebsiteResourceUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.TextAnchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BenchmarkReport {
    public static final int CHARTED_SCORE_LEVEL_SIZE = 5;
    protected final DefaultPlannerBenchmark plannerBenchmark;
    protected Locale locale;
    protected File htmlOverviewFile = null;
    protected List<File> bestScoreSummaryChartFileList = null;
    protected List<File> winningScoreDifferenceSummaryChartFileList = null;
    protected List<File> worstScoreDifferencePercentageSummaryChartFileList = null;
    protected File timeSpendSummaryChartFile = null;
    protected File scalabilitySummaryChartFile = null;
    protected File averageCalculateCountSummaryChartFile = null;
    protected Integer defaultShownScoreLevelIndex = null;

    public BenchmarkReport(DefaultPlannerBenchmark plannerBenchmark) {
        this.plannerBenchmark = plannerBenchmark;
    }

    public DefaultPlannerBenchmark getPlannerBenchmark() {
        return this.plannerBenchmark;
    }

    public File getHtmlOverviewFile() {
        return this.htmlOverviewFile;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<File> getBestScoreSummaryChartFileList() {
        return this.bestScoreSummaryChartFileList;
    }

    public List<File> getWinningScoreDifferenceSummaryChartFileList() {
        return this.winningScoreDifferenceSummaryChartFileList;
    }

    public List<File> getWorstScoreDifferencePercentageSummaryChartFileList() {
        return this.worstScoreDifferencePercentageSummaryChartFileList;
    }

    public File getTimeSpendSummaryChartFile() {
        return this.timeSpendSummaryChartFile;
    }

    public File getScalabilitySummaryChartFile() {
        return this.scalabilitySummaryChartFile;
    }

    public File getAverageCalculateCountSummaryChartFile() {
        return this.averageCalculateCountSummaryChartFile;
    }

    public Integer getDefaultShownScoreLevelIndex() {
        return this.defaultShownScoreLevelIndex;
    }

    public void writeReport() {
        this.writeBestScoreSummaryCharts();
        this.writeWinningScoreDifferenceSummaryChart();
        this.writeWorstScoreDifferencePercentageSummaryChart();
        this.writeTimeSpendSummaryChart();
        this.writeScalabilitySummaryChart();
        this.writeAverageCalculateCountPerSecondSummaryChart();
        for (ProblemBenchmark problemBenchmark : this.plannerBenchmark.getUnifiedProblemBenchmarkList()) {
            if (!problemBenchmark.hasAnySuccess()) continue;
            for (ProblemStatistic problemStatistic : problemBenchmark.getProblemStatisticList()) {
                problemStatistic.writeStatistic();
            }
        }
        this.determineDefaultShownScoreLevelIndex();
        this.writeHtmlOverviewFile();
    }

    private void writeBestScoreSummaryCharts() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = singleBenchmark.getScore().toDoubleLevels();
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.bestScoreSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Score level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Best score level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.bestScoreSummaryChartFileList.add(this.writeChartToImageFile(chart, "bestScoreSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWinningScoreDifferenceSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = singleBenchmark.getWinningScoreDifference().toDoubleLevels();
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.winningScoreDifferenceSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Winning score difference level " + scoreLevelIndex, NumberFormat.getInstance(this.locale));
            JFreeChart chart = new JFreeChart("Winning score difference level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.winningScoreDifferenceSummaryChartFileList.add(this.writeChartToImageFile(chart, "winningScoreDifferenceSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeWorstScoreDifferencePercentageSummaryChart() {
        ArrayList<DefaultCategoryDataset> datasetList = new ArrayList<DefaultCategoryDataset>(5);
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                double[] levelValues = singleBenchmark.getWorstScoreDifferencePercentage().getPercentageLevels();
                for (int i = 0; i < levelValues.length && i < 5; ++i) {
                    if (i >= datasetList.size()) {
                        datasetList.add(new DefaultCategoryDataset());
                    }
                    ((DefaultCategoryDataset)datasetList.get(i)).addValue(levelValues[i], (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
                }
            }
        }
        this.worstScoreDifferencePercentageSummaryChartFileList = new ArrayList<File>(datasetList.size());
        int scoreLevelIndex = 0;
        for (DefaultCategoryDataset dataset : datasetList) {
            CategoryPlot plot = this.createBarChartPlot(dataset, "Worst score difference percentage level " + scoreLevelIndex, NumberFormat.getPercentInstance(this.locale));
            JFreeChart chart = new JFreeChart("Worst score difference percentage level " + scoreLevelIndex + " summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            this.worstScoreDifferencePercentageSummaryChartFileList.add(this.writeChartToImageFile(chart, "worstScoreDifferencePercentageSummaryLevel" + scoreLevelIndex));
            ++scoreLevelIndex;
        }
    }

    private void writeTimeSpendSummaryChart() {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                String planningProblemLabel = singleBenchmark.getProblemBenchmark().getName();
                if (!singleBenchmark.isSuccess()) continue;
                long timeMillisSpend = singleBenchmark.getTimeMillisSpend();
                dataset.addValue((double)timeMillisSpend, (Comparable)((Object)solverLabel), (Comparable)((Object)planningProblemLabel));
            }
        }
        CategoryPlot plot = this.createBarChartPlot(dataset, "Time spend", new MillisecondsSpendNumberFormat(this.locale));
        JFreeChart chart = new JFreeChart("Time spend summary (lower time is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.timeSpendSummaryChartFile = this.writeChartToImageFile(chart, "timeSpendSummary");
    }

    private void writeScalabilitySummaryChart() {
        NumberAxis xAxis = new NumberAxis("Problem scale");
        xAxis.setNumberFormatOverride(NumberFormat.getInstance(this.locale));
        NumberAxis yAxis = new NumberAxis("Time spend");
        yAxis.setNumberFormatOverride((NumberFormat)new MillisecondsSpendNumberFormat(this.locale));
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                long problemScale = singleBenchmark.getProblemBenchmark().getProblemScale();
                long timeMillisSpend = singleBenchmark.getTimeMillisSpend();
                series.add((Number)problemScale, (Number)timeMillisSpend);
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Scalability summary (lower is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.scalabilitySummaryChartFile = this.writeChartToImageFile(chart, "scalabilitySummary");
    }

    private void writeAverageCalculateCountPerSecondSummaryChart() {
        NumberAxis xAxis = new NumberAxis("Problem scale");
        xAxis.setNumberFormatOverride(NumberFormat.getInstance(this.locale));
        NumberAxis yAxis = new NumberAxis("Average calculate count per second");
        yAxis.setNumberFormatOverride(NumberFormat.getInstance(this.locale));
        XYPlot plot = new XYPlot(null, (ValueAxis)xAxis, (ValueAxis)yAxis, null);
        int seriesIndex = 0;
        for (SolverBenchmark solverBenchmark : this.plannerBenchmark.getSolverBenchmarkList()) {
            String solverLabel = solverBenchmark.getNameWithFavoriteSuffix();
            XYSeries series = new XYSeries((Comparable)((Object)solverLabel));
            for (SingleBenchmark singleBenchmark : solverBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                long problemScale = singleBenchmark.getProblemBenchmark().getProblemScale();
                long averageCalculateCountPerSecond = singleBenchmark.getAverageCalculateCountPerSecond();
                series.add((Number)problemScale, (Number)averageCalculateCountPerSecond);
            }
            XYSeriesCollection seriesCollection = new XYSeriesCollection();
            seriesCollection.addSeries(series);
            plot.setDataset(seriesIndex, (XYDataset)seriesCollection);
            StandardXYItemRenderer renderer = new StandardXYItemRenderer(3);
            renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            plot.setRenderer(seriesIndex, (XYItemRenderer)renderer);
            ++seriesIndex;
        }
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart("Average calculate count summary (higher is better)", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
        this.averageCalculateCountSummaryChartFile = this.writeChartToImageFile(chart, "averageCalculateCountSummary");
    }

    private CategoryPlot createBarChartPlot(DefaultCategoryDataset dataset, String yAxisLabel, NumberFormat numberFormat) {
        CategoryAxis xAxis = new CategoryAxis("Data");
        xAxis.setCategoryMargin(0.4);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setNumberFormatOverride(numberFormat);
        BarRenderer renderer = this.createBarChartRenderer(numberFormat);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        return plot;
    }

    private BarRenderer createBarChartRenderer(NumberFormat numberFormat) {
        BarRenderer renderer = new BarRenderer();
        ItemLabelPosition positiveItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        renderer.setBasePositiveItemLabelPosition(positiveItemLabelPosition);
        ItemLabelPosition negativeItemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        renderer.setBaseNegativeItemLabelPosition(negativeItemLabelPosition);
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator("{2}", numberFormat));
        renderer.setBaseItemLabelsVisible(true);
        return renderer;
    }

    private File writeChartToImageFile(JFreeChart chart, String fileNameBase) {
        BufferedImage chartImage = chart.createBufferedImage(1024, 768);
        File summaryChartFile = new File(this.plannerBenchmark.getBenchmarkReportDirectory(), fileNameBase + ".png");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(summaryChartFile);
            ImageIO.write((RenderedImage)chartImage, "png", out);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Problem writing summaryChartFile: " + summaryChartFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        return summaryChartFile;
    }

    private void determineDefaultShownScoreLevelIndex() {
        this.defaultShownScoreLevelIndex = Integer.MAX_VALUE;
        for (ProblemBenchmark problemBenchmark : this.plannerBenchmark.getUnifiedProblemBenchmarkList()) {
            if (!problemBenchmark.hasAnySuccess()) continue;
            double[] winningScoreLevels = problemBenchmark.getWinningSingleBenchmark().getScore().toDoubleLevels();
            int[] differenceCount = new int[winningScoreLevels.length];
            for (int i = 0; i < differenceCount.length; ++i) {
                differenceCount[i] = 0;
            }
            for (SingleBenchmark singleBenchmark : problemBenchmark.getSingleBenchmarkList()) {
                if (!singleBenchmark.isSuccess()) continue;
                double[] scoreLevels = singleBenchmark.getScore().toDoubleLevels();
                for (int i = 0; i < scoreLevels.length; ++i) {
                    if (scoreLevels[i] == winningScoreLevels[i]) continue;
                    differenceCount[i] = differenceCount[i] + 1;
                }
            }
            int firstInterestingLevel = differenceCount.length - 1;
            for (int i = 0; i < differenceCount.length; ++i) {
                if (differenceCount[i] <= 0) continue;
                firstInterestingLevel = i;
                break;
            }
            if (this.defaultShownScoreLevelIndex <= firstInterestingLevel) continue;
            this.defaultShownScoreLevelIndex = firstInterestingLevel;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeHtmlOverviewFile() {
        WebsiteResourceUtils.copyResourcesTo(this.plannerBenchmark.getBenchmarkReportDirectory());
        this.htmlOverviewFile = new File(this.plannerBenchmark.getBenchmarkReportDirectory(), "index.html");
        Configuration freemarkerCfg = new Configuration();
        freemarkerCfg.setDefaultEncoding("UTF-8");
        freemarkerCfg.setLocale(this.locale);
        freemarkerCfg.setClassForTemplateLoading(BenchmarkReport.class, "");
        String templateFilename = "index.html.ftl";
        HashMap<String, BenchmarkReport> model = new HashMap<String, BenchmarkReport>();
        model.put("benchmarkReport", this);
        OutputStreamWriter writer = null;
        try {
            Template template = freemarkerCfg.getTemplate(templateFilename);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.htmlOverviewFile), "UTF-8");
            template.process(model, (Writer)writer);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Can not read templateFilename (" + templateFilename + ") or write htmlOverviewFile (" + this.htmlOverviewFile + ").", e);
                catch (TemplateException e2) {
                    throw new IllegalArgumentException("Can not process Freemarker templateFilename (" + templateFilename + ") to htmlOverviewFile (" + this.htmlOverviewFile + ").", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

