/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.base.mvel.MVELCompileable;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.Function;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.Wireable;
import org.drools.util.CompositeClassLoader;
import org.mvel2.ParserConfiguration;
import org.mvel2.integration.VariableResolver;
import org.mvel2.integration.impl.MapVariableResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELDialectRuntimeData
implements DialectRuntimeData,
Externalizable {
    private final MapFunctionResolverFactory functionFactory;
    private Map<Wireable, MVELCompileable> invokerLookups;
    private Set<MVELCompileable> mvelReaders;
    private CompositeClassLoader rootClassLoader;
    private List<Wireable> wireList = Collections.emptyList();
    private Map<String, Object> imports;
    private HashSet<String> packageImports;
    private ParserConfiguration parserConfiguration;

    public MVELDialectRuntimeData() {
        this.functionFactory = new MapFunctionResolverFactory();
        this.invokerLookups = new IdentityHashMap<Wireable, MVELCompileable>();
        this.mvelReaders = new HashSet<MVELCompileable>();
        this.imports = new HashMap<String, Object>();
        this.packageImports = new HashSet();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        for (Map.Entry<String, Object> entry : this.imports.entrySet()) {
            if (entry.getValue() instanceof Method) {
                entry.setValue("m:" + ((Method)entry.getValue()).getDeclaringClass().getName());
                continue;
            }
            if (!(entry.getValue() instanceof Field)) continue;
            entry.setValue("f:" + ((Field)entry.getValue()).getDeclaringClass().getName());
        }
        out.writeObject(this.imports);
        out.writeObject(this.packageImports);
        out.writeObject(this.invokerLookups);
        out.writeObject(this.mvelReaders);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.imports = (Map)in.readObject();
        this.packageImports = (HashSet)in.readObject();
        this.invokerLookups = (Map)in.readObject();
        if (!this.invokerLookups.isEmpty()) {
            this.wireList = new ArrayList<Wireable>(this.invokerLookups.keySet());
        }
        this.mvelReaders = (Set)in.readObject();
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData) {
        this.merge(registry, newData, false);
    }

    @Override
    public void merge(DialectRuntimeRegistry registry, DialectRuntimeData newData, boolean excludeClasses) {
        MVELDialectRuntimeData other = (MVELDialectRuntimeData)newData;
        for (Map.Entry<String, Object> entry : other.imports.entrySet()) {
            if (entry.getValue() instanceof Class) {
                if (this.imports.containsKey(entry.getKey())) continue;
                this.imports.put(entry.getKey(), ((Class)entry.getValue()).getName());
                continue;
            }
            if (entry.getValue() instanceof Method) {
                this.imports.put(entry.getKey(), "m:" + ((Method)entry.getValue()).getDeclaringClass().getName());
                continue;
            }
            this.imports.put(entry.getKey(), entry.getValue());
        }
        this.packageImports.addAll(other.packageImports);
        for (Map.Entry<Object, Object> entry : other.invokerLookups.entrySet()) {
            this.invokerLookups.put((Wireable)entry.getKey(), (MVELCompileable)entry.getValue());
            if (this.wireList == Collections.emptyList()) {
                this.wireList = new ArrayList<Wireable>();
            }
            this.wireList.add((Wireable)entry.getKey());
        }
        this.mvelReaders = new HashSet<MVELCompileable>();
        this.mvelReaders.addAll(other.mvelReaders);
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        return this.clone(registry, rootClassLoader, false);
    }

    @Override
    public DialectRuntimeData clone(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader, boolean excludeClasses) {
        MVELDialectRuntimeData clone = new MVELDialectRuntimeData();
        clone.rootClassLoader = rootClassLoader;
        clone.merge(registry, this, excludeClasses);
        clone.onAdd(registry, rootClassLoader);
        return clone;
    }

    @Override
    public void onAdd(DialectRuntimeRegistry registry, CompositeClassLoader rootClassLoader) {
        this.rootClassLoader = rootClassLoader;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public void onBeforeExecute() {
        for (Wireable target : this.wireList) {
            MVELCompileable compileable = this.invokerLookups.get(target);
            compileable.compile(this);
            target.wire(compileable);
        }
        this.wireList.clear();
        for (MVELCompileable compileable : this.mvelReaders) {
            compileable.compile(this);
        }
    }

    public MapFunctionResolverFactory getFunctionFactory() {
        return this.functionFactory;
    }

    @Override
    public void removeRule(Package pkg, Rule rule) {
    }

    public void addFunction(org.mvel2.ast.Function function) {
        this.functionFactory.addFunction(function);
    }

    @Override
    public void removeFunction(Package pkg, Function function) {
        this.functionFactory.removeFunction(function.getName());
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }

    @Override
    public void reload() {
    }

    public ParserConfiguration getParserConfiguration() {
        if (this.parserConfiguration == null) {
            CompositeClassLoader classLoader = this.rootClassLoader;
            String key = null;
            Object value = null;
            try {
                block2: for (Map.Entry<String, Object> entry : this.imports.entrySet()) {
                    Class cls;
                    key = entry.getKey();
                    value = entry.getValue();
                    if (!(entry.getValue() instanceof String)) continue;
                    String str = (String)value;
                    if (str.startsWith("m:")) {
                        cls = this.rootClassLoader.loadClass(str.substring(2));
                        String methodName = key;
                        for (Method method : cls.getDeclaredMethods()) {
                            if (!method.getName().equals(methodName)) continue;
                            entry.setValue(method);
                            continue block2;
                        }
                        continue;
                    }
                    cls = this.rootClassLoader.loadClass(str);
                    entry.setValue(cls);
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to resolve method of field: " + key + " - " + value, e);
            }
            this.parserConfiguration = new ParserConfiguration();
            this.parserConfiguration.setImports(this.imports);
            this.parserConfiguration.setPackageImports(this.packageImports);
            this.parserConfiguration.setClassLoader((ClassLoader)classLoader);
        }
        return this.parserConfiguration;
    }

    public void addImport(String str, Class cls) {
        this.imports.put(str, cls);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addImport(str, cls);
        }
    }

    public void addImport(String str, Method method) {
        this.imports.put(str, method);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addImport(str, method);
        }
    }

    public void addImport(String str, Field field) {
    }

    public void addPackageImport(String str) {
        this.packageImports.add(str);
        if (this.parserConfiguration != null) {
            this.parserConfiguration.addPackageImport(str);
        }
    }

    public void addCompileable(MVELCompileable compilable) {
        this.mvelReaders.add(compilable);
    }

    public void addCompileable(Wireable wireable, MVELCompileable compilable) {
        this.invokerLookups.put(wireable, compilable);
    }

    public Map<Wireable, MVELCompileable> getLookup() {
        return this.invokerLookups;
    }

    public CompositeClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapFunctionResolverFactory
    extends MapVariableResolverFactory
    implements Externalizable {
        public MapFunctionResolverFactory() {
            super(new HashMap());
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.variables);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.variables = (Map)in.readObject();
        }

        public void addFunction(org.mvel2.ast.Function function) {
            this.variables.put(function.getName(), function);
        }

        public void removeFunction(String functionName) {
            this.variables.remove(functionName);
            this.variableResolvers.remove(functionName);
        }

        public VariableResolver createVariable(String name, Object value) {
            throw new RuntimeException("variable is a read-only function pointer");
        }

        public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
            throw new RuntimeException("variable is a read-only function pointer");
        }
    }
}

