/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.WindowNode;
import org.drools.reteoo.WindowTuple;
import org.drools.reteoo.WindowTupleList;
import org.drools.rule.Behavior;

public class SlidingLengthWindow
implements Externalizable,
Behavior {
    private int size;

    public SlidingLengthWindow() {
        this(0);
    }

    public SlidingLengthWindow(int size) {
        this.size = size;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
    }

    public Behavior.BehaviorType getType() {
        return Behavior.BehaviorType.LENGTH_WINDOW;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Object createContext() {
        return new SlidingLengthWindowContext(this.size);
    }

    public boolean assertFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        window.pos = (window.pos + 1) % window.handles.length;
        if (window.handles[window.pos] != null) {
            EventFactHandle previous = window.handles[window.pos];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 5, null, null, previous);
            WindowTupleList list = (WindowTupleList)memory.events.get(previous);
            WindowTuple tuple = list.getFirstWindowTuple();
            while (tuple != null) {
                tuple.getRightTupleSink().retractRightTuple(tuple, propagationContext, workingMemory);
                propagationContext.evaluateActionQueue(workingMemory);
                ((RightTuple)tuple).unlinkFromRightParent();
                tuple = list.getFirstWindowTuple();
            }
        }
        window.handles[window.pos] = (EventFactHandle)handle;
        return true;
    }

    public void retractFact(WindowNode.WindowMemory memory, Object context, InternalFactHandle handle, InternalWorkingMemory workingMemory) {
        SlidingLengthWindowContext window = (SlidingLengthWindowContext)context;
        int last = window.pos == 0 ? window.handles.length - 1 : window.pos - 1;
        int i = window.pos;
        while (i != last) {
            if (window.handles[i] == handle) {
                window.handles[i] = null;
                break;
            }
            i = (i + 1) % window.handles.length;
        }
    }

    public void expireFacts(WindowNode.WindowMemory memory, Object context, InternalWorkingMemory workingMemory) {
    }

    public long getExpirationOffset() {
        return -1L;
    }

    public String toString() {
        return "SlidingLengthWindow( size=" + this.size + " )";
    }

    public static class SlidingLengthWindowContext
    implements Externalizable {
        public EventFactHandle[] handles;
        public int pos = 0;

        public SlidingLengthWindowContext(int size) {
            this.handles = new EventFactHandle[size];
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.pos = in.readInt();
            this.handles = (EventFactHandle[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.pos);
            out.writeObject(this.handles);
        }
    }
}

