/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.app;

import org.drools.planner.config.XmlSolverFactory;
import org.drools.planner.core.Solver;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.persistence.CloudBalancingGenerator;

public class CloudBalancingHelloWorld {
    public static void main(String[] args) {
        XmlSolverFactory solverFactory = new XmlSolverFactory("/org/drools/planner/examples/cloudbalancing/solver/cloudBalancingSolverConfig.xml");
        Solver solver = solverFactory.buildSolver();
        CloudBalance unsolvedCloudBalance = new CloudBalancingGenerator().createCloudBalance(400, 1200);
        solver.setPlanningProblem(unsolvedCloudBalance);
        solver.solve();
        CloudBalance solvedCloudBalance = (CloudBalance)solver.getBestSolution();
        System.out.println("\nSolved cloudBalance with 400 computers and 1200 processes:\n" + CloudBalancingHelloWorld.toDisplayString(solvedCloudBalance));
    }

    public static String toDisplayString(CloudBalance cloudBalance) {
        StringBuilder displayString = new StringBuilder();
        for (CloudProcess process : cloudBalance.getProcessList()) {
            CloudComputer computer = process.getComputer();
            displayString.append("  ").append(process.getLabel()).append(" -> ").append(computer == null ? null : computer.getLabel()).append("\n");
        }
        return displayString.toString();
    }
}

