/*
 * Decompiled with CFR 0.152.
 */
package org.drools.planner.examples.cloudbalancing.swingui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang.ObjectUtils;
import org.drools.planner.core.score.director.ScoreDirector;
import org.drools.planner.core.solution.Solution;
import org.drools.planner.core.solver.ProblemFactChange;
import org.drools.planner.examples.cloudbalancing.domain.CloudBalance;
import org.drools.planner.examples.cloudbalancing.domain.CloudComputer;
import org.drools.planner.examples.cloudbalancing.domain.CloudProcess;
import org.drools.planner.examples.cloudbalancing.solver.move.CloudComputerChangeMove;
import org.drools.planner.examples.cloudbalancing.swingui.CloudComputerPanel;
import org.drools.planner.examples.common.swingui.SolutionPanel;

public class CloudBalancingPanel
extends SolutionPanel {
    public static final String LOGO_PATH = "/org/drools/planner/examples/cloudbalancing/swingui/cloudBalancingLogo.png";
    private JPanel computersPanel;
    private CloudComputerPanel unassignedPanel;
    private Map<CloudComputer, CloudComputerPanel> computerToPanelMap;
    private Map<CloudProcess, CloudComputerPanel> processToPanelMap;

    public CloudBalancingPanel() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        JPanel headerPanel = this.createHeaderPanel();
        JPanel computersPanel = this.createComputersPanel();
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(headerPanel).addComponent(computersPanel));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(headerPanel, -2, -2, -2).addComponent(computersPanel, -2, -2, -2));
    }

    private JPanel createHeaderPanel() {
        JPanel headerPanel = new JPanel(new GridLayout(0, 5));
        JLabel emptyLabel = new JLabel("");
        headerPanel.add(emptyLabel);
        JLabel cpuPowerLabel = new JLabel("CPU power");
        headerPanel.add(cpuPowerLabel);
        JLabel memoryLabel = new JLabel("Memory");
        headerPanel.add(memoryLabel);
        JLabel networkBandwidthLabel = new JLabel("Network bandwidth");
        headerPanel.add(networkBandwidthLabel);
        JLabel costLabel = new JLabel("Cost");
        headerPanel.add(costLabel);
        return headerPanel;
    }

    private JPanel createComputersPanel() {
        this.computersPanel = new JPanel(new GridLayout(0, 1));
        this.unassignedPanel = new CloudComputerPanel(this, null);
        this.computersPanel.add(this.unassignedPanel);
        this.computerToPanelMap = new LinkedHashMap<CloudComputer, CloudComputerPanel>();
        this.computerToPanelMap.put(null, this.unassignedPanel);
        this.processToPanelMap = new LinkedHashMap<CloudProcess, CloudComputerPanel>();
        return this.computersPanel;
    }

    public boolean isRefreshScreenDuringSolving() {
        return true;
    }

    private CloudBalance getCloudBalance() {
        return (CloudBalance)this.solutionBusiness.getSolution();
    }

    public void resetPanel(Solution solution) {
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            if (computerPanel.getComputer() == null) continue;
            this.computersPanel.remove(computerPanel);
        }
        this.computerToPanelMap.clear();
        this.computerToPanelMap.put(null, this.unassignedPanel);
        this.processToPanelMap.clear();
        this.unassignedPanel.clearProcess();
        this.updatePanel(solution);
    }

    public void updatePanel(Solution solution) {
        CloudComputerPanel deadComputerPanel;
        CloudBalance cloudBalance = (CloudBalance)solution;
        LinkedHashSet<CloudComputer> deadCloudComputerSet = new LinkedHashSet<CloudComputer>(this.computerToPanelMap.keySet());
        deadCloudComputerSet.remove(null);
        for (CloudComputer computer : cloudBalance.getComputerList()) {
            deadCloudComputerSet.remove(computer);
            CloudComputerPanel computerPanel = this.computerToPanelMap.get(computer);
            if (computerPanel != null) continue;
            computerPanel = new CloudComputerPanel(this, computer);
            this.computersPanel.add(computerPanel);
            this.computerToPanelMap.put(computer, computerPanel);
        }
        LinkedHashSet<CloudProcess> deadCloudProcessSet = new LinkedHashSet<CloudProcess>(this.processToPanelMap.keySet());
        for (CloudProcess process : cloudBalance.getProcessList()) {
            deadCloudProcessSet.remove(process);
            CloudComputerPanel computerPanel = this.processToPanelMap.get(process);
            CloudComputer computer = process.getComputer();
            if (computerPanel != null && !ObjectUtils.equals((Object)computerPanel.getComputer(), (Object)computer)) {
                this.processToPanelMap.remove(process);
                computerPanel.removeProcess(process);
                computerPanel = null;
            }
            if (computerPanel != null) continue;
            computerPanel = this.computerToPanelMap.get(computer);
            computerPanel.addProcess(process);
            this.processToPanelMap.put(process, computerPanel);
        }
        for (CloudProcess deadProcess : deadCloudProcessSet) {
            deadComputerPanel = this.processToPanelMap.remove(deadProcess);
            deadComputerPanel.removeProcess(deadProcess);
        }
        for (CloudComputer deadComputer : deadCloudComputerSet) {
            deadComputerPanel = this.computerToPanelMap.remove(deadComputer);
            this.computersPanel.remove(deadComputerPanel);
        }
        for (CloudComputerPanel computerPanel : this.computerToPanelMap.values()) {
            computerPanel.update();
        }
    }

    public void deleteComputer(final CloudComputer computer) {
        this.logger.info("Scheduling delete of computer ({}).", (Object)computer);
        this.solutionBusiness.doProblemFactChange(new ProblemFactChange(){

            public void doChange(ScoreDirector scoreDirector) {
                CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
                for (CloudProcess process : cloudBalance.getProcessList()) {
                    if (!ObjectUtils.equals((Object)process.getComputer(), (Object)computer)) continue;
                    scoreDirector.beforeEntityRemoved(process);
                    process.setComputer(null);
                    scoreDirector.afterEntityRemoved(process);
                }
                Iterator<CloudComputer> it = cloudBalance.getComputerList().iterator();
                while (it.hasNext()) {
                    CloudComputer workingComputer = it.next();
                    if (!ObjectUtils.equals((Object)workingComputer, (Object)computer)) continue;
                    scoreDirector.beforeProblemFactRemoved(workingComputer);
                    it.remove();
                    scoreDirector.beforeProblemFactRemoved(workingComputer);
                    break;
                }
            }
        });
        this.updatePanel(this.solutionBusiness.getSolution());
    }

    private class CloudProcessAction
    extends AbstractAction {
        private CloudProcess process;

        public CloudProcessAction(CloudProcess process) {
            super("=>");
            this.process = process;
        }

        public void actionPerformed(ActionEvent e) {
            List<CloudComputer> computerList = CloudBalancingPanel.this.getCloudBalance().getComputerList();
            JComboBox<Object> computerListField = new JComboBox<Object>(computerList.toArray());
            computerListField.setSelectedItem(this.process.getComputer());
            int result = JOptionPane.showConfirmDialog(CloudBalancingPanel.this.getRootPane(), computerListField, "Select computer", 2);
            if (result == 0) {
                CloudComputer toComputer = (CloudComputer)computerListField.getSelectedItem();
                CloudBalancingPanel.this.solutionBusiness.doMove(new CloudComputerChangeMove(this.process, toComputer));
                CloudBalancingPanel.this.solverAndPersistenceFrame.resetScreen();
            }
        }
    }
}

